/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.Constants;
import com.c24rew.deepin.Validations;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BeaconSearchAlgorithm {
    private static final int ROD_RADIUS = 15;
    private static final int ROD_SPACING = 9;
    private static final int BEACON_BASE_LINE_SEARCH_LENGTH = 12;
    private static final int BEACON_SEARCH_RADIUS = 3;
    private Direction currentDirection;
    private float rodLineLength;
    private int stepsTaken;
    private final ServerLevel world;
    private final BlockPos center;

    public BeaconSearchAlgorithm(ServerLevel world, BlockPos center) {
        this.world = world;
        this.center = center;
        this.currentDirection = Direction.NORTH;
        this.rodLineLength = 1.0f;
        this.stepsTaken = 0;
    }

    public Set<BlockPos> searchBeacon() {
        this.stepsTaken = 0;
        this.rodLineLength = 1.0f;
        this.currentDirection = Direction.NORTH;
        HashSet<BlockPos> beaconMaterialsPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> beaconPositions = new HashSet<BlockPos>();
        BlockPos rodSearchPosition = this.center;
        while (rodSearchPosition != null) {
            this.searchRod(rodSearchPosition, beaconMaterialsPositions);
            rodSearchPosition = this.getNextRodPosition(rodSearchPosition);
        }
        if (beaconMaterialsPositions.isEmpty()) {
            return new HashSet<BlockPos>();
        }
        for (BlockPos pos : beaconMaterialsPositions) {
            this.findBeaconFromBase(pos, beaconPositions);
        }
        if (beaconPositions.isEmpty()) {
            return new HashSet<BlockPos>();
        }
        HashSet<BlockPos> validBeaconPositions = new HashSet<BlockPos>();
        for (BlockPos beaconPos : beaconPositions) {
            if (!Validations.validateBeacon(this.world, beaconPos)) continue;
            validBeaconPositions.add(beaconPos);
        }
        return validBeaconPositions;
    }

    private void searchRod(BlockPos center, Set<BlockPos> positions) {
        int maxHeight;
        int minY = this.world.getMinY();
        int maxY = center.getY() + 50 + 1;
        if (maxY > (maxHeight = this.world.getHeight() - minY - 1)) {
            maxY = maxHeight;
        }
        int centerX = center.getX();
        int centerZ = center.getZ();
        boolean lastPosWasBeaconMaterial = false;
        for (int y = minY; y <= maxY; ++y) {
            BlockPos pos = new BlockPos(centerX, y, centerZ);
            Block block = this.world.getBlockState(pos).getBlock();
            if (!Constants.BEACON_MATERIALS.contains(block)) {
                lastPosWasBeaconMaterial = false;
                continue;
            }
            if (lastPosWasBeaconMaterial) continue;
            positions.add(pos);
            lastPosWasBeaconMaterial = true;
        }
    }

    private BlockPos getNextRodPosition(BlockPos lastRodPosition) {
        int x = lastRodPosition.getX();
        int z = lastRodPosition.getZ();
        switch (this.currentDirection.ordinal()) {
            case 0: {
                z -= 9;
                break;
            }
            case 1: {
                z += 9;
                break;
            }
            case 2: {
                x += 9;
                break;
            }
            case 3: {
                x -= 9;
            }
        }
        ++this.stepsTaken;
        if (this.stepsTaken > 15) {
            return null;
        }
        if ((double)this.stepsTaken >= Math.floor(this.rodLineLength)) {
            this.stepsTaken = 0;
            this.rodLineLength += 0.5f;
            this.currentDirection = this.currentDirection.next();
        }
        return new BlockPos(x, lastRodPosition.getY(), z);
    }

    private void findBeaconFromBase(BlockPos pos, Set<BlockPos> beaconPositions) {
        BlockPos blockPos;
        boolean foundBeaconMaterial;
        BlockPos xCenterPos = this.getCenterPos(pos, true);
        if (xCenterPos == null) {
            return;
        }
        BlockPos zCenterPos = this.getCenterPos(xCenterPos, false);
        if (zCenterPos == null) {
            return;
        }
        for (int y = zCenterPos.getY() + 5 - 1; y <= zCenterPos.getY() + 5 && (foundBeaconMaterial = this.findBeaconsFromBeacon(blockPos = new BlockPos(zCenterPos.getX(), y, zCenterPos.getZ()), beaconPositions)); ++y) {
        }
    }

    private BlockPos getCenterPos(BlockPos initialPos, boolean isXAxis) {
        BlockPos firstBeaconMaterialBlockPos = null;
        int beaconMaterialLength = 0;
        for (int i = 0; i <= 25; ++i) {
            BlockPos currentPos = isXAxis ? initialPos.offset(i - 12, 0, 0) : initialPos.offset(0, 0, i - 12);
            Block block = this.world.getBlockState(currentPos).getBlock();
            if (!Constants.BEACON_MINERAL_BLOCKS.contains(block)) {
                if (firstBeaconMaterialBlockPos == null) continue;
                break;
            }
            if (firstBeaconMaterialBlockPos == null) {
                firstBeaconMaterialBlockPos = currentPos;
            }
            ++beaconMaterialLength;
        }
        if (firstBeaconMaterialBlockPos == null || beaconMaterialLength < 9) {
            return null;
        }
        if (isXAxis) {
            int xCenter = firstBeaconMaterialBlockPos.getX() + beaconMaterialLength / 2;
            return new BlockPos(xCenter, initialPos.getY(), initialPos.getZ());
        }
        int zCenter = firstBeaconMaterialBlockPos.getZ() + beaconMaterialLength / 2;
        return new BlockPos(initialPos.getX(), initialPos.getY(), zCenter);
    }

    private boolean findBeaconsFromBeacon(BlockPos beaconPos, Set<BlockPos> beaconPositions) {
        boolean foundBeaconMaterial = false;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos currentPos = beaconPos.offset(x, y, z);
                    Block block = this.world.getBlockState(currentPos).getBlock();
                    if (block == Blocks.BEACON) {
                        beaconPositions.add(currentPos);
                    }
                    if (!Constants.BEACON_MATERIALS.contains(block)) continue;
                    foundBeaconMaterial = true;
                }
            }
        }
        return foundBeaconMaterial;
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;


        public Direction next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EAST;
                case 2 -> SOUTH;
                case 1 -> WEST;
                case 3 -> NORTH;
            };
        }
    }
}

