/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.BeaconCache;
import com.c24rew.deepin.BeaconSearchAlgorithm;
import com.c24rew.deepin.Constants;
import com.c24rew.deepin.Validations;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.utils.value.IntValue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MainListener {
    public static void init() {
        BlockEvent.BREAK.register(MainListener::blockBreakEvent);
    }

    private static EventResult blockBreakEvent(Level world, BlockPos blockPos, BlockState blockState, ServerPlayer serverPlayerEntity, @Nullable IntValue intValue) {
        if (serverPlayerEntity == null || !(world instanceof ServerLevel) || blockPos == null || blockState == null) {
            return EventResult.pass();
        }
        if (world.isClientSide()) {
            return EventResult.pass();
        }
        if (!Constants.DEEPSLATE_BLOCKS.contains(blockState.getBlock())) {
            return EventResult.pass();
        }
        if (!Constants.NETHERITE_TOOLS.contains(serverPlayerEntity.getMainHandItem().getItem())) {
            return EventResult.pass();
        }
        BlockPos cachedBeaconPos = BeaconCache.cachedPlayersBeacons.getOrDefault(serverPlayerEntity.getUUID(), null);
        if (cachedBeaconPos == null) {
            if (!MainListener.searchAndCacheBeacon((ServerLevel)world, serverPlayerEntity)) {
                return EventResult.pass();
            }
            cachedBeaconPos = BeaconCache.cachedPlayersBeacons.get(serverPlayerEntity.getUUID());
        }
        if (Validations.getBeaconSecondaryEffect((ServerLevel)world, cachedBeaconPos) == MobEffects.HASTE.value() && Validations.isPlayerOnBeaconRange(serverPlayerEntity, cachedBeaconPos)) {
            MainListener.updatePlayerHaste(serverPlayerEntity);
        } else {
            MainListener.removePlayerHaste(serverPlayerEntity, cachedBeaconPos);
        }
        return EventResult.pass();
    }

    private static void updatePlayerHaste(ServerPlayer serverPlayerEntity) {
        BeaconCache.removePlayerFromRemoveQueue(serverPlayerEntity);
        MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.HASTE, 10, 7, false, true, false);
        serverPlayerEntity.addEffect(effectInstance);
    }

    private static void removePlayerHaste(ServerPlayer serverPlayerEntity, BlockPos cachedBeaconPos) {
        if (!BeaconCache.IsPlayerOnRemoveQueue(serverPlayerEntity)) {
            return;
        }
        serverPlayerEntity.removeEffect(MobEffects.HASTE);
        BeaconCache.addPlayerToRemoveQueue(serverPlayerEntity);
        if (!Validations.isPlayerOnBeaconRange(serverPlayerEntity, cachedBeaconPos) && Validations.playerHasHaste2(serverPlayerEntity)) {
            MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.HASTE, 120, 1, false, true, true);
            serverPlayerEntity.addEffect(effectInstance);
        }
    }

    private static boolean searchAndCacheBeacon(ServerLevel serverWorld, ServerPlayer serverPlayerEntity) {
        if (!Validations.playerHasHaste2(serverPlayerEntity)) {
            return false;
        }
        for (BlockPos beaconPos : new BeaconSearchAlgorithm(serverWorld, serverPlayerEntity.blockPosition()).searchBeacon()) {
            if (!Validations.beaconHasHaste2(serverWorld, beaconPos) || !Validations.isPlayerOnBeaconRange(serverPlayerEntity, beaconPos)) continue;
            BeaconCache.cachedPlayersBeacons.put(serverPlayerEntity.getUUID(), beaconPos);
            return true;
        }
        return false;
    }
}

