/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.DeepIn;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Validations {
    public static boolean validateBeacon(ServerLevel serverWorld, BlockPos beaconPos) {
        if (!(serverWorld.getBlockEntity(beaconPos) instanceof BeaconBlockEntity)) {
            return false;
        }
        if (!Validations.hasBeamAccess(serverWorld, beaconPos)) {
            return false;
        }
        return Validations.getBeaconLevel(serverWorld, beaconPos) > 0;
    }

    public static int getBeaconLevel(ServerLevel serverWorld, BlockPos beaconPos) {
        BlockEntity blockEntity = serverWorld.getBlockEntity(beaconPos);
        if (!(blockEntity instanceof BeaconBlockEntity)) {
            return 0;
        }
        BeaconBlockEntity beacon = (BeaconBlockEntity)blockEntity;
        try {
            CompoundTag nbt = beacon.saveWithoutMetadata((HolderLookup.Provider)serverWorld.registryAccess());
            if (!nbt.contains("Levels")) {
                return 0;
            }
            Optional levelsOptional = nbt.getInt("Levels");
            return levelsOptional.orElse(0);
        }
        catch (Exception e) {
            DeepIn.LOGGER.error("Error accessing beacon level from NBT: {}", (Object)e.getMessage());
            return 0;
        }
    }

    private static boolean hasBeamAccess(ServerLevel world, BlockPos beaconPos) {
        int maxHeight = world.getHeight() - world.getMinY() - 1;
        for (int y = beaconPos.getY() + 1; y < maxHeight; ++y) {
            BlockPos checkPos = new BlockPos(beaconPos.getX(), y, beaconPos.getZ());
            if (world.getBlockState(checkPos).propagatesSkylightDown() || world.getBlockState(checkPos).getBlock() == Blocks.BEDROCK) continue;
            return false;
        }
        return true;
    }

    public static MobEffect getBeaconSecondaryEffect(ServerLevel serverWorld, BlockPos beaconPos) {
        if (!Validations.validateBeacon(serverWorld, beaconPos)) {
            return null;
        }
        BeaconBlockEntity beacon = (BeaconBlockEntity)serverWorld.getBlockEntity(beaconPos);
        if (beacon == null) {
            return null;
        }
        try {
            CompoundTag nbt = beacon.saveWithoutMetadata((HolderLookup.Provider)serverWorld.registryAccess());
            if (!nbt.contains("secondary_effect")) {
                return null;
            }
            Optional secondaryEffectOptional = nbt.getString("secondary_effect");
            if (secondaryEffectOptional.isEmpty()) {
                return null;
            }
            String secondaryEffectId = (String)secondaryEffectOptional.get();
            ResourceLocation effectId = ResourceLocation.tryParse((String)secondaryEffectId);
            if (effectId == null) {
                return null;
            }
            return (MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(effectId);
        }
        catch (Exception e) {
            DeepIn.LOGGER.error("Error accessing beacon secondary effect from NBT: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean beaconHasHaste2(ServerLevel world, BlockPos beaconPos) {
        MobEffect statusEffect = Validations.getBeaconSecondaryEffect(world, beaconPos);
        if (statusEffect == null) {
            return false;
        }
        return statusEffect == MobEffects.HASTE.value();
    }

    public static boolean isPlayerOnBeaconRange(ServerPlayer player, BlockPos beaconPos) {
        boolean horizontalIntersection;
        if (player == null || beaconPos == null) {
            return false;
        }
        if (Validations.isPosOnBeaconRange(player.blockPosition(), beaconPos)) {
            return true;
        }
        float width = player.getBbWidth();
        float height = player.getBbHeight();
        double minX = player.getX() - (double)width / 2.0;
        double maxX = player.getX() + (double)width / 2.0;
        double minY = player.getY();
        double maxY = player.getY() + (double)height;
        double minZ = player.getZ() - (double)width / 2.0;
        double maxZ = player.getZ() + (double)width / 2.0;
        double beaconMinX = beaconPos.getX() - 50;
        double beaconMaxX = beaconPos.getX() + 50 + 1;
        double beaconMinZ = beaconPos.getZ() - 50;
        double beaconMaxZ = beaconPos.getZ() + 50 + 1;
        boolean bl = horizontalIntersection = !(maxX <= beaconMinX || minX >= beaconMaxX || maxZ <= beaconMinZ || minZ >= beaconMaxZ);
        if (!horizontalIntersection) {
            return false;
        }
        if (minY >= (double)beaconPos.getY()) {
            return true;
        }
        double beaconMinY = beaconPos.getY() - 50;
        return maxY > beaconMinY;
    }

    public static boolean isPosOnBeaconRange(BlockPos pos, BlockPos beaconPos) {
        if (pos == null || beaconPos == null) {
            return false;
        }
        int dx = Math.abs(pos.getX() - beaconPos.getX());
        int dz = Math.abs(pos.getZ() - beaconPos.getZ());
        if (dx > 50 || dz > 50) {
            return false;
        }
        int dy = pos.getY() - beaconPos.getY();
        if (dy >= 0) {
            return true;
        }
        return Math.abs(dy) <= 50;
    }

    public static boolean playerHasHaste2(ServerPlayer player) {
        if (!player.hasEffect(MobEffects.HASTE)) {
            return false;
        }
        MobEffectInstance statusEffect = player.getEffect(MobEffects.HASTE);
        if (statusEffect == null || statusEffect.getAmplifier() < 1) {
            return false;
        }
        return statusEffect.getDuration() > 0;
    }
}

