package uk.co.cablepost.camera_lock_on.client;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.clientarguments.arguments.CEntityArgument;
import dev.xpple.clientarguments.arguments.CEntitySelector;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_156;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4604;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import uk.co.cablepost.camera_lock_on.config.ModConfig;

import java.util.Objects;
import java.util.UUID;

@Environment(EnvType.CLIENT)
public class CameraLockOnClient implements ClientModInitializer {

    public static class_742 targetPlayer = null;
    public static long lastFrameTime = 0;
    public static UUID keepLockedOnToWhenOutOfRangeUuid = null;
    public static boolean auto = false;
    public static boolean keepLockedOnToWhenOutOfRange = true;
    public static class_243 positionLastTime = null;
    public static boolean justTeleported = false;

    @Override
    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);

        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(
            ClientCommandManager.literal("camera_lock_on")

                .then(
                    ClientCommandManager.literal("player")
                    .then(ClientCommandManager.argument("target", CEntityArgument.player())
                    .executes(context -> {
                        targetPlayer = null;
                        keepLockedOnToWhenOutOfRangeUuid = null;

                        String playerName =context.getInput().split("\\s+")[2];

                        try {
                            targetPlayer = CEntityArgument.getPlayer(context, "target");
                            keepLockedOnToWhenOutOfRangeUuid = targetPlayer.method_5667();
                        }
                        catch(CommandSyntaxException e){
                            if(Objects.equals(e.getMessage(), "No player was found")){
                                var ple = Objects.requireNonNull(class_310.method_1551().method_1562()).method_2874(playerName);
                                if(ple != null) {
                                    keepLockedOnToWhenOutOfRangeUuid = ple.method_2966().getId();
                                }
                                else {
                                    context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Player not found"));
                                    return 1;
                                }
                            }
                            else{
                                throw e;
                            }
                        }

                        if(auto) {
                            auto = false;
                            context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Auto lock on disabled"));
                        }

                        if(targetPlayer != null) {
                            context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Locked on to: " + targetPlayer.method_7334().getName()));
                        }
                        else if(keepLockedOnToWhenOutOfRangeUuid != null){
                            var ple = Objects.requireNonNull(class_310.method_1551().method_1562()).method_2871(keepLockedOnToWhenOutOfRangeUuid);
                            if(ple != null) {
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Locked on to: " + ple.method_2966().getName()));
                            }
                            else{
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Locked on to: " + keepLockedOnToWhenOutOfRangeUuid.toString()));
                            }
                        }
                        else{
                            context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Locked on to: No one"));
                        }
                        return 1;
                    }))
                )

                .then(
                    ClientCommandManager.literal("auto")
                        .executes(context -> {
                            targetPlayer = null;
                            if(!auto) {
                                if(keepLockedOnToWhenOutOfRange){
                                    keepLockedOnToWhenOutOfRange = false;
                                    keepLockedOnToWhenOutOfRangeUuid = null;
                                    context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Keep Locked On To When Out Of Range disabled"));
                                }

                                auto = true;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Auto lock on enabled"));
                            }
                            else{
                                auto = false;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Auto lock on disabled"));
                            }
                            return 1;
                        })
                )

                .then(
                    ClientCommandManager.literal("zoom")
                        .executes(context -> {
                            ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

                            if(!config.zoomToFillFrame) {
                                config.zoomToFillFrame = true;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Zoom enabled"));
                            }
                            else{
                                config.zoomToFillFrame = false;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Zoom disabled"));
                            }
                            return 1;
                        })
                )

                .then(
                    ClientCommandManager.literal("keep_locked_on")
                        .executes(context -> {
                            if(!keepLockedOnToWhenOutOfRange) {
                                if(auto) {
                                    auto = false;
                                    context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Auto lock on disabled"));
                                }

                                keepLockedOnToWhenOutOfRange = true;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Keep Locked On To When Out Of Range enabled"));
                            }
                            else{
                                keepLockedOnToWhenOutOfRange = false;
                                keepLockedOnToWhenOutOfRangeUuid = null;
                                context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Keep Locked On To When Out Of Range disabled"));
                            }

                            return 1;
                        })
                )

                .then(
                    ClientCommandManager.literal("off")
                    .executes(context -> {
                        targetPlayer = null;
                        keepLockedOnToWhenOutOfRangeUuid = null;
                        if(auto) {
                            auto = false;
                            context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Auto lock on disabled"));
                        }
                        context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Disabled"));
                        return 1;
                    })
                )

                .then(
                    ClientCommandManager.literal("hud_status")
                    .executes(context -> {
                        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

                        config.hudStatus = !config.hudStatus;
                        context.getSource().sendFeedback(class_2561.method_43470("[Camera Lock On] Hud status: " + config.hudStatus));
                        return 1;
                    })
                )
        ));

        ClientTickEvents.END_WORLD_TICK.register((context) -> {
            if(class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity) {
                {
                    class_243 playerPos = clientPlayerEntity.method_19538();
                    justTeleported = positionLastTime == null || positionLastTime.method_1022(playerPos) > 10f;
                    positionLastTime = playerPos;
                }

                if (auto) {
                    class_742 closestToCrossHairPlayer = null;
                    int closestToCrossHairDistance = 1000;
                    for(var player : clientPlayerEntity.field_17892.method_18456()){
                        if(
                            player.equals(clientPlayerEntity) ||
                            player.method_7325()
                        ){
                            continue;
                        }

                        int gotToFov = 999;
                        for(int fov = 90; fov >= 0; fov -= 1){
                            boolean inFrame = inFrame(class_310.method_1551(), clientPlayerEntity, player, Math.max(fov, 1));

                            if(!inFrame){
                                break;
                            }

                            gotToFov = fov;
                        }

                        if(gotToFov < closestToCrossHairDistance){
                            closestToCrossHairDistance = gotToFov;
                            closestToCrossHairPlayer = player;
                        }
                    }

                    if(closestToCrossHairPlayer != null && !clientPlayerEntity.equals(closestToCrossHairPlayer)) {
                        if(targetPlayer != null && !closestToCrossHairPlayer.equals(targetPlayer)) {
                            System.out.println("[Camera Lock On] Switching lock to: " + targetPlayer.method_7334().getName() + " who was within " + closestToCrossHairDistance + " FOV from cross-hair");
                        }

                        targetPlayer = closestToCrossHairPlayer;
                        keepLockedOnToWhenOutOfRangeUuid = targetPlayer.method_5667();
                    }
                }

                if (targetPlayer != null) {
                    if(clientPlayerEntity.field_17892.method_18470(targetPlayer.method_5667()) == null){
                        targetPlayer = null;
                    }
                    else{
                        if(keepLockedOnToWhenOutOfRangeUuid == null){
                            keepLockedOnToWhenOutOfRangeUuid = targetPlayer.method_5667();
                        }
                    }
                }
                else{
                    if(keepLockedOnToWhenOutOfRange && keepLockedOnToWhenOutOfRangeUuid != null){
                        if(clientPlayerEntity.field_17892.method_18470(keepLockedOnToWhenOutOfRangeUuid) instanceof class_742 abstractClientPlayerEntity){
                            targetPlayer = abstractClientPlayerEntity;
                        }
                    }
                }
            } else {
                targetPlayer = null;
                keepLockedOnToWhenOutOfRangeUuid = null;
            }
        });

        ClientPlayConnectionEvents.JOIN.register((clientPlayNetworkHandler, packetSender, minecraftClient) -> {
            targetPlayer = null;
            auto = false;
        });

        WorldRenderEvents.LAST.register((context) -> {
            if(targetPlayer != null && class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity) {
                ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();
                double lerpAmt = config.panSpeed;

                long now = class_156.method_658();

                if(lastFrameTime != 0){
                    lerpAmt *= ((now - lastFrameTime) * 0.02d);
                }

                if(justTeleported){
                    lerpAmt = 1f;
                }

                PitchAndYaw targetPitchAndYaw = getPitchAndYawTo(clientPlayerEntity.method_33571(), targetPlayer.method_33571());

                float tickDelta = context.tickCounter().method_60637(true);

                double currentPitch = clientPlayerEntity.method_5695(tickDelta);
                double currentYaw = clientPlayerEntity.method_5705(tickDelta);

                double targetPitch = targetPitchAndYaw.pitch();
                double targetYaw = targetPitchAndYaw.yaw();

                while(targetYaw < currentYaw - 180f){
                    targetYaw += 360f;
                }

                while(targetYaw > currentYaw + 180f){
                    targetYaw -= 360f;
                }

                clientPlayerEntity.method_36457((float)class_3532.method_16436(lerpAmt, currentPitch, targetPitch));
                clientPlayerEntity.method_36456((float)class_3532.method_16436(lerpAmt, currentYaw, targetYaw));

                lastFrameTime = now;
            }
            else{
                lastFrameTime = class_156.method_658();
            }
        });

        HudRenderCallback.EVENT.register((context, tickDeltaManager) -> {
            ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

            if(!config.hudStatus){
                return;
            }

            String lockedOnToName = "(None)";

            if(targetPlayer != null){
                lockedOnToName = targetPlayer.method_7334().getName();
            }

            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Camera Lock On] Locked on to: " + lockedOnToName), 10, 10, 0xFFFFFFFF, true);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Camera Lock On] Auto: " + auto), 10, 20, 0xFFFFFFFF, true);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Camera Lock On] Keep Locked On To When Out Of Range: " + keepLockedOnToWhenOutOfRange), 10, 30, 0xFFFFFFFF, true);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Camera Lock On] Keep Locked On To When Out Of Range UUID: " + (keepLockedOnToWhenOutOfRangeUuid == null ? "(none)" : keepLockedOnToWhenOutOfRangeUuid.toString())), 10, 40, 0xFFFFFFFF, true);
            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Camera Lock On] FOV multiplier: " + getFovMul()), 10, 50, 0xFFFFFFFF, true);
        });
    }

    public static boolean inFrame(class_310 client, class_746 clientPlayerEntity, class_742 toTrack, int fov){
        Quaternionf cameraQuaternionf = new Quaternionf();

        cameraQuaternionf.rotationYXZ((float) Math.PI - clientPlayerEntity.field_6241 * (float) (Math.PI / 180.0), -clientPlayerEntity.method_36455() * (float) (Math.PI / 180.0), 0.0F);

        cameraQuaternionf = cameraQuaternionf.conjugate(new Quaternionf());

        Matrix4f cameraRotationMatrix = new Matrix4f().rotation(cameraQuaternionf);
        Matrix4f projectionMatrix = client.field_1773.method_22973(fov);

        class_4604 cameraFrustum = new class_4604(cameraRotationMatrix, projectionMatrix);
        cameraFrustum.method_23088(clientPlayerEntity.method_23317(), clientPlayerEntity.method_23320(), clientPlayerEntity.method_23321());

        return cameraFrustum.method_23093(
            new class_238(
                toTrack.method_23317() - 1,
                toTrack.method_23318() - 1,
                toTrack.method_23321() - 1,
                toTrack.method_23317() + 1,
                toTrack.method_23318() + 1,
                toTrack.method_23321() + 1
            )
        );
    }

    public static PitchAndYaw getPitchAndYawTo(class_243 from, class_243 to){
        double d = to.field_1352 - from.field_1352;
        double e = to.field_1351 - from.field_1351;
        double f = to.field_1350 - from.field_1350;
        double g = Math.sqrt(d * d + f * f);
        float pitch = class_3532.method_15393((float) (-(class_3532.method_15349(e, g) * 180.0F / (float) Math.PI)));
        float yaw = class_3532.method_15393((float) (class_3532.method_15349(f, d) * 180.0F / (float) Math.PI) - 90.0F);

        return new PitchAndYaw(pitch, yaw);
    }

    public static float getFovMul(){
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(!config.zoomToFillFrame || targetPlayer == null || class_310.method_1551().field_1724 == null){
            return 1f;
        }

        double dis = class_310.method_1551().field_1724.method_33571().method_1022(targetPlayer.method_33571());
        double amt = config.zoomToFillFrameModifier / dis;
        return (float) Math.min(1f, Math.max(0.05f, amt));
    }
}
