package uk.co.cablepost.camera_lock_on.mixin;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import uk.co.cablepost.camera_lock_on.client.CameraLockOnClient;
import uk.co.cablepost.camera_lock_on.config.ModConfig;

@Mixin(class_742.class)
public class AbstractClientPlayerEntityMixin {
    //? if <1.21.3 {
    @Inject(method = "getFovMultiplier()F", at = @At("HEAD"), cancellable = true)
    public void getFovMultiplier(CallbackInfoReturnable<Float> cir){
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(
            config.zoomToFillFrame &&
            CameraLockOnClient.targetPlayer != null &&
            class_310.method_1551().field_1724 != null
        ){
            cir.setReturnValue(CameraLockOnClient.getFovMul());
        }
    }
    //?}
    //? if >=1.21.3 {
    /*@Inject(method = "getFovMultiplier(ZF)F", at = @At("HEAD"), cancellable = true)
    public void getFovMultiplier(boolean firstPerson, float fovEffectScale, CallbackInfoReturnable<Float> cir){
        ModConfig config = AutoConfig.getConfigHolder(ModConfig.class).getConfig();

        if(
            firstPerson &&
            config.zoomToFillFrame &&
            CameraLockOnClient.targetPlayer != null &&
            MinecraftClient.getInstance().player != null
        ){
            cir.setReturnValue(CameraLockOnClient.getFovMul());
        }
    }
    *///?}
}
