/*
 * Decompiled with CFR 0.152.
 */
package com.itamio.elytrafix;

import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="elytrafix", version="1.0", name="Elytra Fix", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class ElytraFixMod {
    public static final String MODID = "elytrafix";
    public static final String NAME = "Elytra Fix";
    public static final String VERSION = "1.0";
    private static final Logger LOGGER = LogManager.getLogger((String)"elytrafix");
    private static final int TARGET_ENTITY_ID = 507;
    private static Field entityIdField = null;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("ElytraFix mod initialized - will force player entity ID to {}", (Object)507);
        this.findEntityIdField();
    }

    private void findEntityIdField() {
        try {
            String[] possibleFieldNames;
            for (String fieldName : possibleFieldNames = new String[]{"entityId", "field_145783_c", "field_70152_h", "field_145784_d", "entityID", "id", "entityid", "ENTITY_ID"}) {
                try {
                    Field field = Entity.class.getDeclaredField(fieldName);
                    if (field.getType() != Integer.TYPE) continue;
                    entityIdField = field;
                    entityIdField.setAccessible(true);
                    LOGGER.info("Found entity ID field: {}", (Object)fieldName);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (entityIdField == null) {
                LOGGER.error("Could not find entity ID field automatically.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error finding entity ID field", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (entityIdField != null) {
                try {
                    try {
                        Field modifiersField = Field.class.getDeclaredField("modifiers");
                        modifiersField.setAccessible(true);
                        modifiersField.setInt(entityIdField, entityIdField.getModifiers() & 0xFFFFFFEF);
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.warn("Could not remove final modifier, trying anyway...");
                    }
                    int currentId = (Integer)entityIdField.get(player);
                    if (currentId != 507) {
                        entityIdField.set(player, 507);
                        LOGGER.info("Set player entity ID to {} during construction (was: {})", (Object)507, (Object)currentId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to set entity ID during construction", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.func_145782_y() != 507) {
                LOGGER.info("Player {} has entity ID {}, changing to {}", (Object)player.func_70005_c_(), (Object)player.func_145782_y(), (Object)507);
                if (entityIdField != null) {
                    try {
                        entityIdField.set(player, 507);
                        LOGGER.info("Successfully changed {}'s entity ID to {}", (Object)player.func_70005_c_(), (Object)player.func_145782_y());
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to change entity ID for player {}", (Object)player.func_70005_c_(), (Object)e);
                    }
                }
            } else {
                LOGGER.info("Player {} already has correct entity ID: {}", (Object)player.func_70005_c_(), (Object)player.func_145782_y());
            }
        }
    }
}

