/*
 * Decompiled with CFR 0.152.
 */
package com.itamio.elytrafix.asm;

import java.util.List;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PlayerEntityTransformer
implements IClassTransformer {
    private static final String[] TARGET_CLASSES = new String[]{"net.minecraft.entity.player.EntityPlayer", "net.minecraft.entity.player.EntityPlayerMP"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean shouldTransform = false;
        for (String target : TARGET_CLASSES) {
            if (!target.equals(transformedName)) continue;
            shouldTransform = true;
            break;
        }
        if (!shouldTransform) {
            return basicClass;
        }
        System.out.println("[ElytraFix] Transforming player class: " + transformedName);
        try {
            ClassReader classReader = new ClassReader(basicClass);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 6);
            boolean foundConstructor = false;
            List methods = classNode.methods;
            for (MethodNode method : methods) {
                if (!method.name.equals("<init>")) continue;
                System.out.println("[ElytraFix] Found constructor in " + transformedName + ", injecting entity ID override...");
                this.injectEntityIdOverride(method, transformedName);
                foundConstructor = true;
            }
            if (!foundConstructor) {
                System.out.println("[ElytraFix] Warning: No constructor found in " + transformedName);
            }
            ClassWriter classWriter = new ClassWriter(2);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            System.err.println("[ElytraFix] Error transforming player class " + transformedName + ": " + e.getMessage());
            return basicClass;
        }
    }

    private void injectEntityIdOverride(MethodNode method, String className) {
        InsnList instructions = method.instructions;
        AbstractInsnNode insertionPoint = this.findSafeInsertionPoint(instructions);
        if (insertionPoint != null) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInject.add((AbstractInsnNode)new LdcInsnNode((Object)507));
            toInject.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "field_145783_c", "I"));
            instructions.insert(insertionPoint, toInject);
            System.out.println("[ElytraFix] Successfully injected entity ID override in " + className);
        } else {
            System.out.println("[ElytraFix] Warning: Could not find safe insertion point in constructor of " + className);
        }
    }

    private AbstractInsnNode findSafeInsertionPoint(InsnList instructions) {
        ListIterator iterator = instructions.iterator();
        boolean foundSuperCall = false;
        while (iterator.hasNext()) {
            AbstractInsnNode instruction = (AbstractInsnNode)iterator.next();
            if (instruction.getOpcode() == 183) {
                MethodInsnNode methodCall = (MethodInsnNode)instruction;
                if (methodCall.name.equals("<init>")) {
                    foundSuperCall = true;
                    return instruction.getNext();
                }
            }
            if (!foundSuperCall && instruction.getOpcode() == 25 && ((VarInsnNode)instruction).var != 0) continue;
        }
        return instructions.getFirst();
    }
}

