/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.incrediblecustomswords.entity;

import javax.annotation.Nullable;
import net.mcreator.incrediblecustomswords.init.IncredibleCustomSwordsModEntities;
import net.mcreator.incrediblecustomswords.init.IncredibleCustomSwordsModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ClutchSwordWaterPorjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)IncredibleCustomSwordsModItems.WATERPROJECTILE_USED.get());
    private int knockback = 0;

    public ClutchSwordWaterPorjectileEntity(EntityType<? extends ClutchSwordWaterPorjectileEntity> type, Level world) {
        super(type, world);
    }

    public ClutchSwordWaterPorjectileEntity(EntityType<? extends ClutchSwordWaterPorjectileEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    public ClutchSwordWaterPorjectileEntity(EntityType<? extends ClutchSwordWaterPorjectileEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IncredibleCustomSwordsModItems.WATERPROJECTILE_USED.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        } else {
            super.doKnockback(livingEntity, damageSource);
        }
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static ClutchSwordWaterPorjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return ClutchSwordWaterPorjectileEntity.shoot(world, entity, source, 0.4f, 2.4, 1);
    }

    public static ClutchSwordWaterPorjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return ClutchSwordWaterPorjectileEntity.shoot(world, entity, source, pullingPower * 0.4f, 2.4, 1);
    }

    public static ClutchSwordWaterPorjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        ClutchSwordWaterPorjectileEntity entityarrow = new ClutchSwordWaterPorjectileEntity((EntityType<? extends ClutchSwordWaterPorjectileEntity>)((EntityType)IncredibleCustomSwordsModEntities.CLUTCH_SWORD_WATER_PORJECTILE.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static ClutchSwordWaterPorjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        ClutchSwordWaterPorjectileEntity entityarrow = new ClutchSwordWaterPorjectileEntity((EntityType<? extends ClutchSwordWaterPorjectileEntity>)((EntityType)IncredibleCustomSwordsModEntities.CLUTCH_SWORD_WATER_PORJECTILE.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 0.8f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(2.4);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

