/*
 * Decompiled with CFR 0.152.
 */
package com.rethink.itemtool.handler;

import com.rethink.itemtool.config.ItemToolConfig;
import java.util.ArrayList;
import net.minecraft.class_1542;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;

public record ItemDataHandler(class_2561 name, class_243 pos, class_243 velocity, double speed, boolean onGround, int age, int lifeSpan, int pickUpDelay, int portalCooldown, int count, boolean isSimulationTick, class_238 tryMergeBox) {
    public static ItemDataHandler formNBT(class_1542 entity, class_2487 nbt) {
        class_2561 name = entity.method_5477();
        class_2499 nbtPos = nbt.method_10554("Pos", 6);
        class_2499 nbtVelocity = nbt.method_10554("Motion", 6);
        class_243 velocity = new class_243(nbtVelocity.method_10611(0), nbtVelocity.method_10611(1), nbtVelocity.method_10611(2));
        velocity = ItemToolConfig.ItemVelocityMeterPerSecond ? velocity.method_1021(20.0) : velocity;
        double speed = velocity.method_37268();
        class_243 pos = new class_243(nbtPos.method_10611(0), nbtPos.method_10611(1), nbtPos.method_10611(2));
        boolean onGround = nbt.method_10577("OnGround");
        int age = nbt.method_10550("Age");
        int lifeSpan = 6000 - age;
        int pickupDelay = nbt.method_10550("PickupDelay");
        int portalCooldown = nbt.method_10550("PortalCooldown");
        int count = nbt.method_10562("Item").method_10550("count");
        boolean isSimulationTick = ItemDataHandler.getIsSimulationTick(entity.method_5628(), age, speed, onGround);
        return new ItemDataHandler(name, pos, velocity, speed, onGround, age, lifeSpan, pickupDelay, portalCooldown, count, isSimulationTick, entity.method_5829());
    }

    public static boolean getIsSimulationTick(int id, int age, double speed, boolean onGround) {
        return !onGround || speed > (double)1.0E-5f || (id + age) % 4 == 0;
    }

    public ArrayList<class_2561> getInfoTexts() {
        ArrayList<class_2561> infoTexts = new ArrayList<class_2561>();
        if (ItemToolConfig.ItemName) {
            infoTexts.add(this.name());
        }
        if (ItemToolConfig.ItemVelocity && this.velocity() != null) {
            infoTexts.add(this.getVelocityText());
        }
        if (ItemToolConfig.ItemSpeed) {
            infoTexts.add(this.getSpeedText());
        }
        if (ItemToolConfig.ItemPosition) {
            infoTexts.add(this.getPosText());
        }
        if (ItemToolConfig.ItemCount && this.count() != 0) {
            infoTexts.add(this.getCountText());
        }
        if (ItemToolConfig.ItemOnGround) {
            infoTexts.add(this.getOnGroundText());
        }
        if (ItemToolConfig.ItemAge && this.age() != 0) {
            infoTexts.add(this.getAgeText());
        }
        if (ItemToolConfig.ItemLifeSpan) {
            infoTexts.add(this.getLifeSpaText());
        }
        if (ItemToolConfig.ItemPickDelay) {
            infoTexts.add(this.getPickDelayText());
        }
        if (ItemToolConfig.ItemPortalCooldown) {
            infoTexts.add(this.getPortalCooldownText());
        }
        if (ItemToolConfig.ItemIsSimulationTick) {
            infoTexts.add(this.getIsSimulationTickText());
        }
        return infoTexts;
    }

    private class_2561 getIsSimulationTickText() {
        return class_2561.method_43471((String)"itemtool.settings.item_is_simulation_tick").method_10852(class_2561.method_30163((String)String.valueOf(this.isSimulationTick)));
    }

    private class_2561 getPosText() {
        return class_2561.method_43471((String)"itemtool.settings.item_position").method_27693(ItemDataHandler.formatVec3d(this.pos));
    }

    private class_2561 getSpeedText() {
        return class_2561.method_43471((String)"itemtool.settings.item_speed").method_10852(class_2561.method_30163((String)String.format(ItemDataHandler.getDoubleFormatString(), this.speed)));
    }

    private class_2561 getPortalCooldownText() {
        return class_2561.method_43471((String)"itemtool.settings.item_portal_cooldown").method_10852(class_2561.method_30163((String)String.valueOf(this.portalCooldown)));
    }

    private class_2561 getPickDelayText() {
        return class_2561.method_43471((String)"itemtool.settings.item_pick_delay").method_10852(class_2561.method_30163((String)String.valueOf(this.pickUpDelay)));
    }

    private class_2561 getLifeSpaText() {
        return class_2561.method_43471((String)"itemtool.settings.item_life_span").method_10852(class_2561.method_30163((String)String.valueOf(this.lifeSpan)));
    }

    private class_2561 getAgeText() {
        return class_2561.method_43471((String)"itemtool.settings.item_age").method_10852(class_2561.method_30163((String)String.valueOf(this.age)));
    }

    private class_2561 getOnGroundText() {
        return class_2561.method_43471((String)"itemtool.settings.item_on_ground").method_10852(class_2561.method_30163((String)String.valueOf(this.onGround)));
    }

    private class_2561 getCountText() {
        if (this.count == 0) {
            return class_2561.method_43471((String)"itemtool.settings.item_count").method_10852((class_2561)class_2561.method_43471((String)"itemtool.unknown"));
        }
        return class_2561.method_43471((String)"itemtool.settings.item_count").method_10852(class_2561.method_30163((String)String.valueOf(this.count)));
    }

    private class_2561 getVelocityText() {
        if (this.velocity == null) {
            return class_2561.method_43471((String)"itemtool.settings.item_velocity").method_10852((class_2561)class_2561.method_43471((String)"itemtool.unknown"));
        }
        return class_2561.method_43471((String)"itemtool.settings.item_velocity").method_27693(ItemDataHandler.formatVec3d(this.velocity));
    }

    private static String formatVec3d(class_243 vec) {
        return "[" + String.format(ItemDataHandler.getDoubleFormatString(), vec.field_1352) + ", " + String.format(ItemDataHandler.getDoubleFormatString(), vec.field_1351) + ", " + String.format(ItemDataHandler.getDoubleFormatString(), vec.field_1350) + "]";
    }

    private static String getDoubleFormatString() {
        return "%." + Math.abs(ItemToolConfig.ItemDisplayPrecision) + "f";
    }
}

