/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.gui.inventory.implementation;

import com.artillexstudios.axafkzone.libs.axapi.context.HashMapContext;
import com.artillexstudios.axafkzone.libs.axapi.gui.inventory.Gui;
import com.artillexstudios.axafkzone.libs.axapi.gui.inventory.GuiItem;
import com.artillexstudios.axafkzone.libs.axapi.gui.inventory.modifier.WrappedItemStackModifier;
import com.artillexstudios.axafkzone.libs.axapi.gui.inventory.provider.GuiItemProvider;
import com.artillexstudios.axafkzone.libs.axapi.gui.inventory.provider.implementation.EmptyGuiItemProvider;
import com.artillexstudios.axafkzone.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.mutable.MutableInteger;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;

public class PaginatedGui
extends Gui {
    private final HashMap<Class<?>, Function<?, GuiItemProvider>> customProviders;
    private final List<GuiItemProvider> otherProviders = new ArrayList<GuiItemProvider>();
    private int page = 0;
    private int pageSize = this.size;
    private Supplier<List<?>> itemsProvider;

    public PaginatedGui(Player player, Function<HashMapContext, Component> titleProvider, InventoryType type, int rows, HashMap<Class<?>, Function<?, GuiItemProvider>> providers, HashMapContext context, List<WrappedItemStackModifier> modifiers) {
        super(player, titleProvider, type, rows, context, modifiers);
        this.customProviders = providers;
    }

    public <T> void addItem(T item) {
        Function<Object, GuiItemProvider> guiItemProviderProvider = this.provide(item);
        this.otherProviders.add(guiItemProviderProvider.apply(item));
    }

    public <T> void setItems(List<T> items, boolean same) {
        this.otherProviders.clear();
        if (!same) {
            for (T item : items) {
                this.addItem(item);
            }
        } else {
            Function<Object, GuiItemProvider> provider = null;
            for (T item : items) {
                if (provider == null) {
                    provider = this.provide(item);
                }
                this.otherProviders.add(provider.apply(item));
            }
        }
    }

    public <T> void setItems(List<T> items) {
        this.setItems(items, false);
    }

    public void setItemsProvider(Supplier<List<?>> itemsProvider) {
        this.itemsProvider = itemsProvider;
    }

    private Function<Object, GuiItemProvider> provide(Object item) {
        Class<?> clazz = item.getClass();
        Function<Object, GuiItemProvider> function = this.customProviders.get(clazz);
        if (function != null) {
            return function;
        }
        for (Class<?> cl : ClassUtils.INSTANCE.superClasses(clazz)) {
            function = this.customProviders.get(cl);
            if (function == null) continue;
            return function;
        }
        for (Class<?> cl : ClassUtils.INSTANCE.interfaces(clazz)) {
            function = this.customProviders.get(cl);
            if (function == null) continue;
            return function;
        }
        throw new IllegalStateException("No custom provider for class " + String.valueOf(item.getClass()) + "!");
    }

    @Override
    public void setItem(int slot, GuiItemProvider provider) {
        super.setItem(slot, provider);
        this.recalculatePageSize();
    }

    @Override
    public void setItem(int slot, GuiItem item, Function<GuiItem, GuiItemProvider> provider) {
        super.setItem(slot, item, provider);
        this.recalculatePageSize();
    }

    @Override
    public void setItem(int slot, GuiItem item) {
        super.setItem(slot, item);
        this.recalculatePageSize();
    }

    private void recalculatePageSize() {
        MutableInteger size = new MutableInteger();
        this.providers.forEach((s, pv) -> {
            if (pv instanceof EmptyGuiItemProvider) {
                size.increment();
            }
        });
        this.pageSize = size.get();
    }

    public int page() {
        return this.page;
    }

    @Override
    public void open() {
        if (this.itemsProvider != null) {
            List<?> objects = this.itemsProvider.get();
            this.setItems(objects, true);
        }
        if (this.page >= this.maxPages()) {
            this.page = this.maxPages() - 1;
        }
        super.open();
    }

    public void page(int page) {
        if (page >= this.maxPages()) {
            throw new IllegalStateException("Max pages: " + this.maxPages());
        }
        if (page < 0) {
            throw new IllegalStateException("Min page is 0!");
        }
        this.page = page;
    }

    public int maxPages() {
        int size = this.otherProviders.size();
        if (size == 0) {
            return 1;
        }
        return Math.ceilDiv(size, this.pageSize);
    }

    public boolean hasNextPage() {
        return this.page + 1 < this.maxPages();
    }

    public boolean hasPreviousPage() {
        return this.page > 0;
    }

    public boolean hasPage(int page) {
        return page < this.maxPages() && page >= 0;
    }

    @Override
    public Int2ObjectArrayMap<GuiItemProvider> getProviders() {
        if (this.pageSize == 0 && !this.otherProviders.isEmpty()) {
            LogUtils.warn("This paginated gui has no empty slots for the provided items!", new Object[0]);
            LogUtils.warn("Please create some empty slots for them!", new Object[0]);
            return super.getProviders();
        }
        int index = this.page * this.pageSize;
        Int2ObjectArrayMap pageProviders = super.getProviders().clone();
        for (Int2ObjectMap.Entry entry : pageProviders.int2ObjectEntrySet()) {
            if (!(entry.getValue() instanceof EmptyGuiItemProvider)) continue;
            if (index >= this.otherProviders.size()) break;
            entry.setValue((Object)this.otherProviders.get(index));
            ++index;
        }
        return pageProviders;
    }
}

