/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.packet;

import com.artillexstudios.axafkzone.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axafkzone.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axafkzone.libs.axapi.packet.PacketListener;
import com.artillexstudios.axafkzone.libs.axapi.packet.PacketSide;
import com.artillexstudios.axafkzone.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axafkzone.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axafkzone.libs.axapi.utils.featureflags.exception.IllegalFeatureFlagStateException;
import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

public enum PacketEvents {
    INSTANCE;

    private final ObjectArrayList<PacketListener> listeners = new ObjectArrayList();
    private PacketListener[] baked = new PacketListener[0];
    private boolean listening = false;

    public void addListener(PacketListener listener) {
        if (!((Boolean)FeatureFlags.ENABLE_PACKET_LISTENERS.get()).booleanValue()) {
            throw new IllegalFeatureFlagStateException("Packet listeners!");
        }
        this.listeners.add((Object)listener);
        this.listening = true;
        this.baked = (PacketListener[])this.listeners.toArray((Object[])new PacketListener[0]);
    }

    public void callEvent(PacketEvent event) {
        PacketListener[] baked;
        if (!this.listening) {
            return;
        }
        for (PacketListener listener : baked = this.baked) {
            try {
                if (event.side() == PacketSide.CLIENT_BOUND) {
                    listener.onPacketSending(event);
                } else {
                    listener.onPacketReceive(event);
                }
            }
            catch (Throwable throwable) {
                LogUtils.error("Failed to read {} packet!", new Object[]{event.side(), throwable});
                continue;
            }
            PacketWrapper wrapper = event.wrapper();
            if (wrapper == null) continue;
            FriendlyByteBuf out = event.out();
            wrapper.write(out);
        }
    }

    public boolean listening() {
        return this.listening;
    }
}

