/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.packetentity.tracker;

import com.artillexstudios.axafkzone.libs.axapi.AxPlugin;
import com.artillexstudios.axafkzone.libs.axapi.collections.IdentityArrayMap;
import com.artillexstudios.axafkzone.libs.axapi.collections.RawReferenceOpenHashSet;
import com.artillexstudios.axafkzone.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axafkzone.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axafkzone.libs.axapi.nms.wrapper.WorldWrapper;
import com.artillexstudios.axafkzone.libs.axapi.packetentity.PacketEntity;
import com.artillexstudios.axafkzone.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axafkzone.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.Version;
import com.artillexstudios.axafkzone.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class EntityTracker {
    private static final boolean folia = PaperUtils.isFolia();
    private final ConcurrentHashMap<Integer, TrackedEntity> entityMap = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<TrackedEntity> trackingQueue = new ConcurrentLinkedQueue();
    private final FieldAccessor accessor = FieldAccessor.builder().withField("tracker").withClass("com.artillexstudios.axafkzone.libs.axapi.nms.%s.entity.PacketEntity".formatted(Version.getServerVersion().getNMSVersion())).build();
    private ScheduledExecutorService service;
    private final AxPlugin instance;

    public EntityTracker(AxPlugin instance) {
        this.instance = instance;
    }

    public void startTicking() {
        this.shutdown();
        this.service = new ExceptionReportingScheduledThreadPool((int)((Integer)FeatureFlags.PACKET_ENTITY_TRACKER_THREADS.get()), new ThreadFactoryBuilder().setNameFormat(this.instance.getName() + "-EntityTracker-%s").build());
        this.service.scheduleAtFixedRate(() -> {
            try {
                this.process();
            }
            catch (Exception exception) {
                if (exception instanceof ConcurrentModificationException) {
                    if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                        LogUtils.error("Caught ConcurrentModificationException when processing packet entities!", exception);
                    }
                    return;
                }
                LogUtils.error("An unexpected error occurred while processing packet entities via the tracker!", exception);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.service == null) {
            return;
        }
        this.service.shutdown();
        try {
            this.service.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException exception) {
            LogUtils.error("Failed to shut down EntityTracker service!", exception);
        }
    }

    public PacketEntity getById(int id) {
        TrackedEntity entity = this.entityMap.get(id);
        return entity == null ? null : entity.entity;
    }

    public void addEntity(PacketEntity entity) {
        TrackedEntity trackedEntity = new TrackedEntity(entity);
        this.accessor.setVolatile(entity, trackedEntity);
        this.entityMap.put(entity.id(), trackedEntity);
        trackedEntity.updateTracking(TrackedEntity.getPlayersInWorld(entity.location().getWorld()));
    }

    public void removeEntity(PacketEntity entity) {
        TrackedEntity trackedEntity = this.entityMap.remove(entity.id());
        if (trackedEntity != null) {
            trackedEntity.broadcastRemove();
        }
        this.accessor.setVolatile(entity, null);
    }

    public void untrackFor(ServerPlayerWrapper player) {
        for (TrackedEntity tracker : this.entityMap.values()) {
            tracker.untrack(player);
        }
    }

    public PacketEntity findRider(int vehicleId) {
        for (TrackedEntity tracker : this.entityMap.values()) {
            if (tracker.entity.riddenEntity() != vehicleId) continue;
            return tracker.entity;
        }
        return null;
    }

    public void process() {
        if (!this.trackingQueue.isEmpty()) {
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.warn("The tracker queue has not been drained yet! This means that tracking took longer than a tick! Increase the entity tracker thread count! Tracker size: {}", this.trackingQueue.size());
            }
            return;
        }
        List worlds = Bukkit.getWorlds();
        IdentityArrayMap<World, List<ServerPlayerWrapper>> tracking = new IdentityArrayMap<World, List<ServerPlayerWrapper>>(worlds.size() + 1);
        for (World world : worlds) {
            tracking.put(world, TrackedEntity.getPlayersInWorld(world));
        }
        this.trackingQueue.addAll(this.entityMap.values());
        for (int i = 0; i < (Integer)FeatureFlags.PACKET_ENTITY_TRACKER_THREADS.get(); ++i) {
            this.service.execute(() -> {
                TrackedEntity tracked;
                while ((tracked = this.trackingQueue.poll()) != null) {
                    tracked.preTick();
                    if (tracked.world == null) {
                        LogUtils.warn("Failed to track entity with id {} due to it being in a null world! Removing the entity!", tracked.entity.id());
                        this.entityMap.remove(tracked.entity.id());
                        continue;
                    }
                    List players = (List)tracking.get(tracked.world);
                    if (players == null) {
                        LogUtils.warn("Failed to track entity with id {} in world {}, due to tracker players being null! Removing the entity! Tracking: {}", tracked.entity.id(), tracked.world.getName(), tracking);
                        this.entityMap.remove(tracked.entity.id());
                        continue;
                    }
                    tracked.updateTracking(players);
                    if (!tracked.hasViewers()) continue;
                    tracked.entity.sendChanges();
                }
            });
        }
    }

    public static class TrackedEntity {
        public final ReferenceSet<Object> seenBy = ReferenceSets.synchronize(new RawReferenceOpenHashSet());
        private final PacketEntity entity;
        private final World world;
        private List<ServerPlayerWrapper> lastTrackerCandidates;
        private boolean hasViewers = false;

        public TrackedEntity(PacketEntity entity) {
            Preconditions.checkNotNull((Object)entity.location().getWorld(), (Object)"Tried to add a TrackedEntity for a PacketEntity in a null world!");
            this.entity = entity;
            this.world = this.entity.location().getWorld();
        }

        public static List<ServerPlayerWrapper> getPlayersInWorld(World world) {
            if (world == null) {
                return ImmutableList.of();
            }
            if (folia) {
                List players = world.getPlayers();
                ArrayList<ServerPlayerWrapper> wrapper = new ArrayList<ServerPlayerWrapper>(players.size());
                for (Player player : players) {
                    wrapper.add(ServerPlayerWrapper.wrap(player));
                }
                return wrapper;
            }
            WorldWrapper wrapper = WorldWrapper.wrap(world);
            return wrapper.players();
        }

        public void updateTracking(@NotNull List<ServerPlayerWrapper> newTrackerCandidates) {
            List<ServerPlayerWrapper> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            for (ServerPlayerWrapper raw : newTrackerCandidates) {
                this.updatePlayer(raw, false);
            }
            if (oldTrackerCandidates != null && oldTrackerCandidates.size() == newTrackerCandidates.size()) {
                return;
            }
            for (Object player : RawReferenceOpenHashSet.rawSet(this.seenBy)) {
                if (player == null) continue;
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                if (!newTrackerCandidates.isEmpty() && newTrackerCandidates.contains(wrapper)) continue;
                this.updatePlayer(wrapper, true);
            }
        }

        public void updatePlayer(ServerPlayerWrapper player, boolean removeStage) {
            boolean flag;
            double dz;
            double dx = player.getX() - this.entity.location().getX();
            double d1 = dx * dx + (dz = player.getZ() - this.entity.location().getZ()) * dz;
            boolean bl = flag = d1 <= (double)this.entity.viewDistanceSquared();
            if (flag && !this.entity.canSee((Player)player.wrapped())) {
                flag = false;
                removeStage = true;
            }
            if (!removeStage && flag) {
                this.hasViewers = true;
                if (this.seenBy.add(player.asMinecraft())) {
                    this.entity.addPairing((Player)player.wrapped());
                }
            } else if (removeStage && this.seenBy.remove(player.asMinecraft())) {
                this.entity.removePairing((Player)player.wrapped());
            }
        }

        public void untrack(ServerPlayerWrapper player) {
            if (!this.seenBy.remove(player.asMinecraft())) {
                return;
            }
            this.entity.removePairing((Player)player.wrapped());
        }

        public void broadcast(Object packet) {
            this.seenBy.forEach(player -> {
                ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                wrapper.sendPacket(packet);
            });
        }

        public void broadcastRemove() {
            this.seenBy.forEach(player -> this.entity.removePairing((Player)ServerPlayerWrapper.wrap(player).wrapped()));
        }

        public void preTick() {
            this.hasViewers = false;
        }

        public boolean hasViewers() {
            return this.hasViewers;
        }
    }
}

