/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class BlacklistUtils {
    private final Map<Object, Object> map;

    public BlacklistUtils(Map<Object, Object> map) {
        this.map = new HashMap<Object, Object>(map);
    }

    @NotNull
    private static List<ItemFlag> getItemFlags(@NotNull List<String> flags) {
        ArrayList<ItemFlag> flagList = new ArrayList<ItemFlag>(flags.size());
        for (String flag : flags) {
            ItemFlag itemFlag;
            try {
                itemFlag = ItemFlag.valueOf((String)flag.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                continue;
            }
            flagList.add(itemFlag);
        }
        return flagList;
    }

    public boolean allows(ItemStack itemStack, boolean strict) {
        Optional<Object> customModelData;
        Optional<Object> lore;
        String displayName;
        Optional<Object> name;
        Optional<Object> flags;
        ItemMeta meta = itemStack.getItemMeta();
        int counter = 0;
        String material = (String)this.map.getOrDefault("type", this.map.get("material"));
        if (material != null && itemStack.getType().name().equalsIgnoreCase(material)) {
            if (strict) {
                ++counter;
            } else {
                return false;
            }
        }
        if ((flags = Optional.ofNullable(this.map.get("item-flags"))).isPresent()) {
            List<ItemFlag> itemFlags = BlacklistUtils.getItemFlags((List)flags.get());
            if (strict) {
                itemFlags.removeAll(meta.getItemFlags());
                if (itemFlags.isEmpty()) {
                    ++counter;
                }
            } else {
                Set metaFlags = meta.getItemFlags();
                for (ItemFlag itemFlag : itemFlags) {
                    if (!metaFlags.contains(itemFlag)) continue;
                    return false;
                }
            }
        }
        if ((name = Optional.ofNullable(this.map.get("name"))).isPresent() && (displayName = meta.getDisplayName()).equalsIgnoreCase((String)name.get())) {
            if (strict) {
                ++counter;
            } else {
                return false;
            }
        }
        if ((lore = Optional.ofNullable(this.map.get("lore"))).isPresent()) {
            List loreLines = (List)flags.get();
            if (strict) {
                loreLines.removeAll(meta.getLore());
                if (loreLines.isEmpty()) {
                    ++counter;
                }
            } else {
                List metaLore = meta.getLore();
                if (metaLore == null) {
                    return false;
                }
                for (String line : metaLore) {
                    if (!loreLines.contains(line)) continue;
                    return false;
                }
            }
        }
        if ((customModelData = Optional.ofNullable(this.map.get("custom-model-data"))).isPresent()) {
            int modelData = meta.getCustomModelData();
            if (customModelData.get().equals(modelData)) {
                if (strict) {
                    ++counter;
                } else {
                    return false;
                }
            }
        }
        if (strict) {
            return counter != this.map.size();
        }
        return true;
    }
}

