/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.reward;

import com.artillexstudios.axafkzone.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axafkzone.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axafkzone.libs.axapi.utils.ContainerUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.ItemBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Reward {
    private final List<String> commands;
    private final List<ItemStack> items;
    private final double chance;
    private final String display;

    public Reward(Map<Object, Object> str) {
        List commands = str.getOrDefault("commands", new ArrayList());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Number chance = (Number)str.get("chance");
        List map = (List)str.get("items");
        if (map != null) {
            LinkedList map2 = new LinkedList(map);
            for (Map it : map2) {
                items.add(ItemBuilder.create(it).get());
            }
        }
        String display = null;
        if (str.containsKey("display")) {
            display = (String)str.get("display");
        }
        this.chance = chance.doubleValue();
        this.items = items;
        this.commands = commands;
        this.display = display;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public double getChance() {
        return this.chance;
    }

    public String getDisplay() {
        return this.display;
    }

    public void run(Player player) {
        Scheduler.get().run((ScheduledTask scheduledTask) -> {
            for (String cmd : this.commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName()));
            }
        });
        ContainerUtils.INSTANCE.addOrDrop((Inventory)player.getInventory(), this.items, player.getLocation());
    }

    public String toString() {
        return "Reward{commands=" + String.valueOf(this.commands) + ", items=" + String.valueOf(this.items) + ", chance=" + this.chance + "}";
    }
}

