/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.utils;

import com.artillexstudios.axafkzone.AxAFKZone;
import com.artillexstudios.axafkzone.libs.axapi.AxPlugin;
import com.artillexstudios.axafkzone.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axafkzone.libs.axapi.utils.NumberUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.StringUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class UpdateNotifier
implements Listener {
    private final int id;
    private final String current;
    private final AxPlugin instance;
    private String latest = null;
    private boolean newest = true;

    public UpdateNotifier(AxPlugin instance, int id) {
        this.id = id;
        this.current = instance.getDescription().getVersion();
        this.instance = instance;
        instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)instance);
        long time = 36000L;
        Scheduler.get().runAsyncTimer(t -> {
            this.latest = this.readVersion();
            this.newest = this.isLatest(this.current);
            if (this.latest == null || this.newest) {
                return;
            }
            Scheduler.get().runLaterAsync(t2 -> Bukkit.getConsoleSender().sendMessage(this.getMessage()), 50L);
            t.cancel();
        }, 0L, time);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.latest == null || this.newest) {
            return;
        }
        if (!AxAFKZone.CONFIG.getBoolean("update-notifier.on-join", true)) {
            return;
        }
        if (!event.getPlayer().hasPermission(this.instance.getName().toLowerCase() + ".update-notify")) {
            return;
        }
        Scheduler.get().runLaterAsync(t -> event.getPlayer().sendMessage(this.getMessage()), 50L);
    }

    private String getMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("%current%", this.current);
        map.put("%latest%", this.latest);
        return StringUtils.formatToString(AxAFKZone.CONFIG.getString("prefix") + AxAFKZone.LANG.getString("update-notifier"), map);
    }

    @Nullable
    private String readVersion() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=" + this.id + "&key=version")).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body().toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getLatest() {
        return this.latest;
    }

    public boolean isLatest(String current) {
        return this.getWeight(this.latest) <= this.getWeight(current);
    }

    private int getWeight(String version) {
        if (version == null) {
            return 0;
        }
        String[] s = version.split("\\.");
        if (!(NumberUtils.isInt(s[0]) && NumberUtils.isInt(s[1]) && NumberUtils.isInt(s[2]))) {
            return 0;
        }
        int res = 0;
        res += Integer.parseInt(s[0]) * 1000000;
        res += Integer.parseInt(s[1]) * 1000;
        return res += Integer.parseInt(s[2]);
    }
}

