/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.libs.axapi.placeholders;

import com.artillexstudios.axafkzone.libs.axapi.context.ContextKey;
import com.artillexstudios.axafkzone.libs.axapi.context.HashMapContext;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.PlaceholderTransformer;
import com.artillexstudios.axafkzone.libs.axapi.placeholders.exception.PlaceholderParameterNotInContextException;
import com.artillexstudios.axafkzone.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.UncheckedUtils;
import com.artillexstudios.axafkzone.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axafkzone.libs.axapi.utils.logging.LogUtils;
import java.util.List;
import java.util.Set;

public class PlaceholderParameters
extends HashMapContext {
    private static final PlaceholderParameterNotInContextException EXCEPTION = new PlaceholderParameterNotInContextException();

    public PlaceholderParameters(HashMapContext context) {
        super(context);
    }

    public PlaceholderParameters() {
    }

    public <T> PlaceholderParameters withParameter(Class<T> clazz, T value) {
        if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Adding parameter class {} with value {}!", clazz, value);
        }
        this.with((ContextKey)ContextKey.of(clazz.getName(), clazz), (Object)value);
        return this;
    }

    public <T> PlaceholderParameters withParameter(T value) {
        Set<Class<?>> classes = ClassUtils.INSTANCE.superClasses(value.getClass(), true);
        classes.addAll(List.of(ClassUtils.INSTANCE.interfaces(value.getClass())));
        for (Class<?> clazz : classes) {
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.debug("Adding parameter class {} with value {}!", clazz, value);
            }
            this.with((ContextKey)UncheckedUtils.unsafeCast(ContextKey.of(clazz.getName(), clazz)), (Object)value);
        }
        return this;
    }

    public PlaceholderParameters withParameters(Object ... values) {
        for (Object value : values) {
            this.withParameter(value);
        }
        return this;
    }

    public <T> boolean contains(Class<T> clazz) {
        return this.getByClass(clazz) != null;
    }

    public <T> T resolve(Class<T> clazz) throws PlaceholderParameterNotInContextException {
        T resolved;
        if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Resolving class {}! Current values: {}", clazz, (Object)this.values);
        }
        if ((resolved = this.raw(clazz)) != null) {
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.debug("Found resolved!");
            }
            return resolved;
        }
        for (PlaceholderTransformer<Object, Object> transformer : PlaceholderHandler.transformers()) {
            if (!transformer.to().equals(clazz)) {
                if (!((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) continue;
                LogUtils.debug("Transformer from: {}, transformer to: {}, class: {}", transformer.from(), transformer.to(), clazz);
                continue;
            }
            try {
                Object other = this.resolve(transformer.from());
                return UncheckedUtils.unsafeCast(transformer.function().apply(other));
            }
            catch (PlaceholderParameterNotInContextException ignored) {
                if (!((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) continue;
                LogUtils.debug("Failed! transformer from: {}, transformer to: {}, class: {}", transformer.from(), transformer.to(), clazz);
            }
        }
        throw EXCEPTION;
    }

    @Override
    public PlaceholderParameters merge(HashMapContext other) {
        super.merge(other);
        return this;
    }

    @Override
    public PlaceholderParameters copy() {
        return new PlaceholderParameters(this);
    }

    @Override
    public <T> PlaceholderParameters with(ContextKey<T> key, T value) {
        super.with(key, value);
        return this;
    }

    public <T> T raw(Class<T> clazz) {
        return UncheckedUtils.unsafeCast(this.getByClass(clazz));
    }
}

