/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axafkzone.utils;

import com.artillexstudios.axafkzone.AxAFKZone;
import com.artillexstudios.axafkzone.libs.axapi.config.Config;
import com.artillexstudios.axafkzone.libs.axapi.serializers.Serializers;
import com.artillexstudios.axafkzone.libs.axapi.utils.StringUtils;
import com.artillexstudios.axafkzone.selection.Selection;
import com.artillexstudios.axafkzone.zones.Zone;
import com.artillexstudios.axafkzone.zones.Zones;
import java.io.File;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;

public class FileUtils {
    public static void loadAll() {
        File path = new File(AxAFKZone.getInstance().getDataFolder(), "zones");
        if (path.exists()) {
            for (File file : path.listFiles()) {
                String fileName = file.getName().replace(".yml", "");
                Zone zone = Zones.getZoneByName(fileName);
                if (zone != null) {
                    zone.reload();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#CC0055\u2560 &#FF8855Reloaded zone &f%name%&#FF8855!".replace("%name%", fileName), new TagResolver[0]));
                    continue;
                }
                FileUtils.load(fileName);
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#CC0055\u2560 &#FF8855Loaded zone &f%name%&#FF8855!".replace("%name%", fileName), new TagResolver[0]));
            }
        }
    }

    public static void create(String zoneName, Selection selection) {
        Config config = new Config(new File(AxAFKZone.getInstance().getDataFolder(), "zones/" + zoneName + ".yml"), AxAFKZone.getInstance().getResource("zones/example-zone.yml"));
        config.set("zone.location1", Serializers.LOCATION.serialize(selection.getPosition1()));
        config.set("zone.location2", Serializers.LOCATION.serialize(selection.getPosition2()));
        config.save();
        FileUtils.load(zoneName);
    }

    public static void load(String zoneName) {
        Config config = new Config(new File(AxAFKZone.getInstance().getDataFolder(), "zones/" + zoneName + ".yml"));
        Zone zone = new Zone(zoneName, config);
        Zones.addZone(zone);
    }

    public static void delete(Zone zone) {
        new File(AxAFKZone.getInstance().getDataFolder(), "zones/" + zone.getName() + ".yml").delete();
        Zones.removeZone(zone);
    }
}

