/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.shapelessportals;

import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private static JavaPlugin plugin;
    private static final MiniMessage miniMessage;
    public static boolean onlyPlayerCanIgnite;
    public static boolean isPermissionRequired;
    public static String permission;
    public static int maxWidth;
    public static int maxHeight;
    public static int minPortalSize;
    public static final Set<Material> portalFrameMaterials;
    public static Component noPermissionToReload;
    public static Component successfullyReloaded;

    public static void init(JavaPlugin plugin) {
        Config.plugin = plugin;
        plugin.saveDefaultConfig();
        Config.reload();
    }

    public static void reload() {
        plugin.reloadConfig();
        FileConfiguration config = plugin.getConfig();
        onlyPlayerCanIgnite = config.getBoolean("onlyPlayerCanIgnite", false);
        isPermissionRequired = config.getBoolean("isPermissionRequired", false);
        permission = config.getString("permission", "");
        maxWidth = config.getInt("maxWidth", 21);
        maxHeight = config.getInt("maxHeight", 21);
        minPortalSize = config.getInt("minPortalSize", 1);
        portalFrameMaterials.clear();
        for (String materialName : config.getStringList("portalFrameMaterials")) {
            Material material = Material.getMaterial((String)materialName);
            if (material == null) {
                plugin.getLogger().warning("Unknown material: " + materialName);
                continue;
            }
            portalFrameMaterials.add(material);
        }
        noPermissionToReload = miniMessage.deserialize((Object)config.getString("noPermissionToReload", "<red>\u2718 <white>You don't have permission!"));
        successfullyReloaded = miniMessage.deserialize((Object)config.getString("successfullyReloaded", "<green>\u2714 <white>Config reloaded!"));
    }

    static {
        miniMessage = MiniMessage.miniMessage();
        portalFrameMaterials = new HashSet<Material>();
    }
}

