/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.shapelessportals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.stokmenn.shapelessportals.Config;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class IgnitePortalListener
implements Listener {
    private final JavaPlugin plugin;

    public IgnitePortalListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        Axis axis;
        Block fireBlock = event.getBlock();
        if (!Config.portalFrameMaterials.contains(fireBlock.getRelative(BlockFace.DOWN).getType())) {
            return;
        }
        World world = fireBlock.getWorld();
        if (world.getEnvironment() == World.Environment.THE_END) {
            return;
        }
        if (Config.onlyPlayerCanIgnite) {
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            if (Config.isPermissionRequired && !player.hasPermission(Config.permission)) {
                return;
            }
        }
        if ((axis = this.getAssumedPortalAxis(world, fireBlock.getLocation())) == null) {
            return;
        }
        Set<Block> portalBlocks = this.getValidPortalBlocks(fireBlock, axis);
        if (portalBlocks == null) {
            axis = axis == Axis.X ? Axis.Z : Axis.X;
            portalBlocks = this.getValidPortalBlocks(fireBlock, axis);
        }
        if (portalBlocks != null) {
            this.buildPortal(portalBlocks, axis, world, event.getIgnitingEntity(), fireBlock.getLocation());
        }
    }

    private Set<Block> getValidPortalBlocks(Block fireBlock, Axis axis) {
        int minZ;
        int minY;
        int minX;
        HashSet<Block> visited = new HashSet<Block>();
        ArrayDeque<Block> queue = new ArrayDeque<Block>();
        int maxX = minX = fireBlock.getX();
        int maxY = minY = fireBlock.getY();
        int maxZ = minZ = fireBlock.getZ();
        visited.add(fireBlock);
        queue.add(fireBlock);
        while (!queue.isEmpty()) {
            Block cur = (Block)queue.poll();
            ArrayList<Block> neighbors = new ArrayList<Block>(4);
            neighbors.add(cur.getRelative(BlockFace.UP));
            neighbors.add(cur.getRelative(BlockFace.DOWN));
            if (axis == Axis.Z) {
                neighbors.add(cur.getRelative(BlockFace.NORTH));
                neighbors.add(cur.getRelative(BlockFace.SOUTH));
            } else {
                neighbors.add(cur.getRelative(BlockFace.EAST));
                neighbors.add(cur.getRelative(BlockFace.WEST));
            }
            for (Block neighbor : neighbors) {
                if (visited.contains(neighbor)) continue;
                Boolean valid = this.isBlockValid(neighbor);
                if (valid == null) {
                    return null;
                }
                if (!valid.booleanValue()) continue;
                visited.add(neighbor);
                queue.add(neighbor);
                int x = neighbor.getX();
                int y = neighbor.getY();
                int z = neighbor.getZ();
                if (axis == Axis.Z) {
                    minZ = Math.min(minZ, z);
                    maxZ = Math.max(maxZ, z);
                } else {
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                }
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                int width = axis == Axis.Z ? maxZ - minZ : maxX - minX;
                int height = maxY - minY;
                if (width < Config.maxWidth && height < Config.maxHeight) continue;
                return null;
            }
        }
        return visited.size() < Config.minPortalSize ? null : visited;
    }

    private void buildPortal(Set<Block> validPortalBlocks, Axis axis, World world, Entity entity, Location location) {
        Bukkit.getRegionScheduler().run((Plugin)this.plugin, location, task -> {
            Orientable portalData = (Orientable)Material.NETHER_PORTAL.createBlockData();
            portalData.setAxis(axis);
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>(validPortalBlocks.size());
            for (Block block : validPortalBlocks) {
                BlockState state2 = block.getState();
                state2.setBlockData((BlockData)portalData);
                blockStates.add(state2);
            }
            PortalCreateEvent event = new PortalCreateEvent(blockStates, world, entity, PortalCreateEvent.CreateReason.FIRE);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                blockStates.forEach(state -> state.update(true));
            }
        });
    }

    private Boolean isBlockValid(Block block) {
        Material material = block.getType();
        if (!material.equals((Object)Material.AIR) && !material.equals((Object)Material.FIRE)) {
            return Config.portalFrameMaterials.contains(material) ? Boolean.valueOf(false) : null;
        }
        return true;
    }

    private Axis getAssumedPortalAxis(World world, Location location) {
        int distance = Config.maxWidth + 1;
        if (this.isValidFrame(world, location, new Vector(0, 0, -1), distance) && this.isValidFrame(world, location, new Vector(0, 0, 1), distance)) {
            return Axis.Z;
        }
        if (this.isValidFrame(world, location, new Vector(1, 0, 0), distance) && this.isValidFrame(world, location, new Vector(-1, 0, 0), distance)) {
            return Axis.X;
        }
        return null;
    }

    private boolean isValidFrame(World world, Location location, Vector direction, int distance) {
        RayTraceResult r = world.rayTraceBlocks(location, direction, (double)distance, FluidCollisionMode.ALWAYS);
        return r != null && r.getHitBlock() != null && Config.portalFrameMaterials.contains(r.getHitBlock().getType());
    }
}

