/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.block;

import net.dakotapride.garnished.item.IGarnishedUtilities;
import net.dakotapride.garnished.registry.GarnishedPaletteStoneTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpecialEffectsBlock
implements IGarnishedUtilities {

    public static class Wyvern {
        public static void getParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
            for (int i = 0; i < 8; ++i) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                int j = random.nextInt(2) * 2 - 1;
                if (!level.getBlockState(pos.west()).is(state.getBlock()) && !level.getBlockState(pos.east()).is(state.getBlock())) {
                    d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                    d3 = random.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                    d5 = random.nextFloat() * 2.0f * (float)j;
                }
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, d0, d1, d2, d3, d4, d5);
            }
        }

        public static void getEffects(Level level, BlockPos pos, BlockState state, Entity entity) {
            RandomSource random = RandomSource.create();
            int effect_list = random.nextInt(10);
            int effect_trigger = random.nextInt(6);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!level.isClientSide) {
                    if (effect_trigger == 1 && effect_list >= 0 && effect_list <= 10) {
                        switch (effect_list) {
                            case 0: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.LUCK);
                                break;
                            }
                            case 1: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED);
                                break;
                            }
                            case 2: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.JUMP);
                                break;
                            }
                            case 3: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE);
                                break;
                            }
                            case 4: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.REGENERATION);
                                break;
                            }
                            case 5: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.GLOWING);
                                break;
                            }
                            case 6: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.DAMAGE_BOOST);
                                break;
                            }
                            case 7: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.DIG_SPEED);
                                break;
                            }
                            case 8: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
                                break;
                            }
                            case 9: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.NIGHT_VISION);
                                break;
                            }
                            case 10: {
                                Wyvern.applyEffectIfNotPresent(living, (Holder<MobEffect>)MobEffects.INVISIBILITY);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + effect_list);
                            }
                        }
                    }
                    if (living.getBlockStateOn().is((Block)GarnishedPaletteStoneTypes.DRAGON_STONE.getBlock().get())) {
                        // empty if block
                    }
                }
            }
        }

        private static void applyEffectIfNotPresent(LivingEntity living, Holder<MobEffect> effect) {
            if (!living.hasEffect(effect)) {
                living.addEffect(new MobEffectInstance(effect, 300, 0));
            }
        }
    }

    public static class Unstable {
        public static void getParticles(BlockPos pos, RandomSource random, Level level, BlockState state, ParticleOptions options) {
            for (int i = 0; i < 4; ++i) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                int j = random.nextInt(2) * 2 - 1;
                if (!level.getBlockState(pos.west()).is(state.getBlock()) && !level.getBlockState(pos.east()).is(state.getBlock())) {
                    d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                    d3 = random.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                    d5 = random.nextFloat() * 2.0f * (float)j;
                }
                level.addParticle(options, d0, d1, d2, d3, d4, d5);
            }
        }

        public static void getEffects(Level level, BlockPos pos, BlockState state, Entity entity) {
            RandomSource random = RandomSource.create();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 1));
            }
        }
    }

    public static class Abyssal {
        public static void getParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
            for (int i = 0; i < 4; ++i) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                int j = random.nextInt(2) * 2 - 1;
                if (!level.getBlockState(pos.west()).is(state.getBlock()) && !level.getBlockState(pos.east()).is(state.getBlock())) {
                    d0 = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                    d3 = random.nextFloat() * 2.0f * (float)j;
                } else {
                    d2 = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                    d5 = random.nextFloat() * 2.0f * (float)j;
                }
                level.addParticle((ParticleOptions)ParticleTypes.ASH, d0, d1, d2, d3, d4, d5);
            }
        }

        public static void getEffects(Level level, BlockPos pos, BlockState state, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 300, 0));
            }
        }
    }
}

