/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.event;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.dakotapride.garnished.item.hatchet.HatchetUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber
public class KilledEntityEvent {
    @SubscribeEvent
    private static void getHatchetLootEnchantmentDropsFromHatchetLootTable(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.getEntity();
        EntityType type = entity.getType();
        if (entity.getServer() != null && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (HatchetUtils.hasRavaging(livingAttacker, livingAttacker.getMainHandItem()) && HatchetUtils.isAffectedByRavaging((Entity)entity)) {
                LootTable lootTable = entity.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).getNamespace(), (String)("entities/ravaging/" + type.toShortString()))));
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)livingAttacker.level()).withParameter(LootContextParams.ORIGIN, (Object)livingAttacker.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingAttacker);
                LootContextParam ctxParameters = LootContextParams.DAMAGE_SOURCE;
                if (livingAttacker instanceof Player) {
                    Player player = (Player)livingAttacker;
                    source = livingAttacker.damageSources().playerAttack(player);
                } else {
                    source = livingAttacker.damageSources().mobAttack(livingAttacker);
                }
                LootParams lootContextParameterSet = builder.withParameter(ctxParameters, (Object)source).create(LootContextParamSets.ENTITY);
                ObjectArrayList list = lootTable.getRandomItems(lootContextParameterSet);
                Objects.requireNonNull(entity);
                list.forEach(arg_0 -> ((LivingEntity)entity).spawnAtLocation(arg_0));
                System.out.println(ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).getNamespace(), (String)("entities/ravaging/" + type.toShortString())));
            } else if (HatchetUtils.hasSalvaging(livingAttacker, livingAttacker.getMainHandItem()) && HatchetUtils.isAffectedBySalvaging((Entity)entity)) {
                LootTable lootTable = entity.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).getNamespace(), (String)("entities/salvaging/" + type.toShortString()))));
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)livingAttacker.level()).withParameter(LootContextParams.ORIGIN, (Object)livingAttacker.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingAttacker);
                LootContextParam ctxParameters = LootContextParams.DAMAGE_SOURCE;
                if (livingAttacker instanceof Player) {
                    Player player = (Player)livingAttacker;
                    source = livingAttacker.damageSources().playerAttack(player);
                } else {
                    source = livingAttacker.damageSources().mobAttack(livingAttacker);
                }
                LootParams lootContextParameterSet = builder.withParameter(ctxParameters, (Object)source).create(LootContextParamSets.ENTITY);
                ObjectArrayList list = lootTable.getRandomItems(lootContextParameterSet);
                Objects.requireNonNull(entity);
                list.forEach(arg_0 -> ((LivingEntity)entity).spawnAtLocation(arg_0));
                System.out.println(ResourceLocation.fromNamespaceAndPath((String)BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).getNamespace(), (String)("entities/salvaging/" + type.toShortString())));
            }
        }
    }
}

