/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import net.dakotapride.garnished.block.IDesolateSpread;
import net.dakotapride.garnished.registry.GarnishedFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.NotNull;

public class DesolateSpreadItem
extends Item {
    public static final int SPREAD_WIDTH = 3;
    public static final int SPREAD_HEIGHT = 1;
    public static final int COUNT_MULTIPLIER = 3;

    public DesolateSpreadItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (this.applySpread(ctx.getItemInHand(), level, pos)) {
            if (!level.isClientSide) {
                // empty if block
            }
            DesolateSpreadItem.getParticles((LevelAccessor)level, pos, 0);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean applySpread(ItemStack stack, Level level, BlockPos pos) {
        IDesolateSpread spreadableBlock;
        BlockState blockstate = level.getBlockState(pos);
        if (level.getBlockState(pos.above()).is(Blocks.AIR) && blockstate.getBlock().defaultBlockState().is(Blocks.END_STONE)) {
            if (level instanceof ServerLevel) {
                if (this.isSuccessful()) {
                    this.performSpread((ServerLevel)level, level.random, pos);
                }
                stack.shrink(1);
            }
            return true;
        }
        Block block = blockstate.getBlock();
        if (block instanceof IDesolateSpread && (spreadableBlock = (IDesolateSpread)block).isValidTarget((BlockGetter)level, pos, blockstate, level.isClientSide)) {
            if (level instanceof ServerLevel) {
                if (spreadableBlock.isSuccess(level, level.random, pos, blockstate)) {
                    spreadableBlock.performSpread((ServerLevel)level, level.random, pos, blockstate);
                }
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public boolean isSuccessful() {
        return true;
    }

    public void performSpread(ServerLevel level, RandomSource random, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        BlockPos blockpos = pos.above();
        ChunkGenerator chunkgenerator = level.getChunkSource().getGenerator();
        Registry registry = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
        if (blockstate.is(Blocks.END_STONE)) {
            this.place(registry, level, chunkgenerator, random, blockpos);
        }
    }

    private void place(Registry<ConfiguredFeature<?, ?>> registry, ServerLevel level, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        registry.getHolder(GarnishedFeatures.END_STONE_VEGETATION_SPREAD_CONFIGURED).ifPresent(p_255920_ -> ((ConfiguredFeature)p_255920_.value()).place((WorldGenLevel)level, generator, random, pos));
    }

    public static void getParticles(LevelAccessor level, BlockPos pos, int data) {
        block7: {
            double d1;
            BlockState blockstate;
            if (data == 0) {
                data = 15;
            }
            if ((blockstate = level.getBlockState(pos)).isAir()) break block7;
            double d0 = 0.5;
            if (blockstate.isSolidRender((BlockGetter)level, pos)) {
                pos = pos.above();
                data *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.getShape((BlockGetter)level, pos).max(Direction.Axis.Y);
            }
            Block block = blockstate.getBlock();
            if (block instanceof IDesolateSpread) {
                IDesolateSpread spreadableBlock = (IDesolateSpread)block;
                level.addParticle((ParticleOptions)spreadableBlock.getParticle(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                randomsource = level.getRandom();
                for (int i = 0; i < data; ++i) {
                    double d8;
                    double d7;
                    double d2 = randomsource.nextGaussian() * 0.02;
                    double d3 = randomsource.nextGaussian() * 0.02;
                    double d4 = randomsource.nextGaussian() * 0.02;
                    double d5 = 0.5 - d0;
                    double d6 = (double)pos.getX() + d5 + randomsource.nextDouble() * d0 * 2.0;
                    if (level.getBlockState(new BlockPos((int)d6, (int)(d7 = (double)pos.getY() + randomsource.nextDouble() * d1), (int)(d8 = (double)pos.getZ() + d5 + randomsource.nextDouble() * d0 * 2.0)).below()).isAir()) continue;
                    level.addParticle((ParticleOptions)spreadableBlock.getParticle(), d6, d7, d8, d2, d3, d4);
                }
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                randomsource = level.getRandom();
                for (int i = 0; i < data; ++i) {
                    double d8;
                    double d7;
                    double d2 = randomsource.nextGaussian() * 0.02;
                    double d3 = randomsource.nextGaussian() * 0.02;
                    double d4 = randomsource.nextGaussian() * 0.02;
                    double d5 = 0.5 - d0;
                    double d6 = (double)pos.getX() + d5 + randomsource.nextDouble() * d0 * 2.0;
                    if (level.getBlockState(new BlockPos((int)d6, (int)(d7 = (double)pos.getY() + randomsource.nextDouble() * d1), (int)(d8 = (double)pos.getZ() + d5 + randomsource.nextDouble() * d0 * 2.0)).below()).isAir()) continue;
                    level.addParticle((ParticleOptions)ParticleTypes.PORTAL, d6, d7, d8, d2, d3, d4);
                }
            }
        }
    }
}

