/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item;

import java.util.List;
import java.util.Random;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.registry.GarnishedEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface IGarnishedUtilities {
    public static final int tick = 20;
    public static final int cinder_dur = 1800;
    public static final int cr_cider_dur = 900;
    public static final int bit_cider_dur = 800;
    public static final int cashew_dur = 1000;
    public static final int almond_dur = 500;
    public static final int tangle_dur = 900;
    public static final int cashew_mix_dur = 3600;
    public static final int cognate_dur = 1200;
    public static final int cane_effect_dur = 200;
    public static final int sugar_high_dur = 500;

    default public void addEffectTooltip(List<Component> tooltip, Holder<MobEffect> effect, int amplifier, float duration) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.applies_effect", (Object[])new Object[]{Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()), amplifier, this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).withStyle(((MobEffect)effect.value()).getCategory().getTooltipFormatting()));
    }

    default public void addEffectTooltip(List<Component> tooltip, Holder<MobEffect> effect, float duration) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.applies_effect.no_amplifier", (Object[])new Object[]{Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()), this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).withStyle(((MobEffect)effect.value()).getCategory().getTooltipFormatting()));
    }

    default public void addEffectTooltipConditionalPositive(List<Component> tooltip, Holder<MobEffect> effect, float duration) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.applies_effect.no_amplifier.conditional.pos", (Object[])new Object[]{Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()).withStyle(ChatFormatting.BLUE), Component.translatable((String)"text.garnished.effect.duration", (Object[])new Object[]{this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).withStyle(((MobEffect)effect.value()).getCategory().getTooltipFormatting())}).withStyle(ChatFormatting.GOLD));
    }

    default public void addEffectTooltipConditionalNegative(List<Component> tooltip, Holder<MobEffect> effect, float duration) {
        tooltip.add((Component)Component.translatable((String)"text.garnished.applies_effect.no_amplifier.conditional.neg", (Object[])new Object[]{Component.translatable((String)((MobEffect)effect.value()).getDescriptionId()).withStyle(ChatFormatting.RED), Component.translatable((String)"text.garnished.effect.duration", (Object[])new Object[]{this.formatDuration(new MobEffectInstance(effect), duration, 1.0f)}).withStyle(((MobEffect)effect.value()).getCategory().getTooltipFormatting())}).withStyle(ChatFormatting.GOLD));
    }

    default public void addChanceForEffect(List<Component> tooltip, float chance) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"text.garnished.applies_effect.chance", (Object[])new Object[]{chance + "%"}).withStyle(ChatFormatting.GRAY));
        }
    }

    default public Component formatDuration(MobEffectInstance effect, float duration, float durationFactor) {
        if (effect.isInfiniteDuration()) {
            return Component.translatable((String)"effect.duration.infinite");
        }
        int i = Mth.floor((float)(duration * durationFactor));
        return Component.literal((String)StringUtil.formatTickDuration((int)i, (float)20.0f));
    }

    default public void triggerConditionalEffect(int value, float chance, LivingEntity entity) {
        boolean has;
        float floatChance = new Random().nextInt(0, 100);
        Level level = entity.level();
        boolean hasSugarHigh = entity.hasEffect(GarnishedEffects.SUGAR_HIGH);
        boolean hasFreezing = entity.hasEffect(GarnishedEffects.FREEZING) || entity.isFreezing();
        boolean hasHunger = entity.hasEffect(MobEffects.HUNGER);
        boolean hasLevitation = entity.hasEffect(MobEffects.LEVITATION);
        boolean hasOmen = entity.hasEffect(MobEffects.BAD_OMEN) || entity.hasEffect(MobEffects.RAID_OMEN) || entity.hasEffect(MobEffects.TRIAL_OMEN);
        boolean isOnFire = entity.isOnFire() || !entity.fireImmune();
        boolean bl = has = floatChance > 0.0f;
        if (!level.isClientSide) {
            if (value == 0 && (has = hasSugarHigh) && floatChance <= chance) {
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 240, 1));
            }
            if (value == 1 && (has = hasFreezing) && floatChance <= chance) {
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 240, 1));
            }
            if (value == 2 && (has = hasHunger) && floatChance <= chance) {
                entity.addEffect(new MobEffectInstance(GarnishedEffects.THORNS, 480, 1));
            }
            if (value == 3 && (has = hasLevitation) && floatChance <= chance) {
                entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 480, 1));
            }
            if (value == 4) {
                has = hasOmen;
                if (has && floatChance <= chance) {
                    entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 720, 1));
                } else {
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 720, 1));
                }
            }
            if (value == 5 && (has = isOnFire) && floatChance <= chance) {
                entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 480, 1));
            }
            if (value == 6) {
                int random = new Random().nextInt(2);
                boolean bl2 = has = random == 1;
                if (random == 1) {
                    entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 900, 2));
                } else {
                    entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 900, 2));
                }
            }
        }
        CreateGarnished.LOGGER.info("achieved float value: {}, requested value: {}, requested value : {}, shouldApply: {}", new Object[]{Float.valueOf(floatChance), Float.valueOf(chance), value, has});
    }
}

