/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.registry;

import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.dakotapride.garnished.CreateGarnished;
import net.dakotapride.garnished.registry.Fluids;
import net.dakotapride.garnished.registry.GarnishedPaletteStoneTypes;
import net.dakotapride.garnished.registry.ZultaniteStoneTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GarnishedFluids
implements Fluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> GARNISH = ((FluidBuilder)GarnishedFluids.standardFluid("garnish", SolidRenderedPlaceableFluidType.create(15722979, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/garnish")}).build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> APPLE_CIDER = ((FluidBuilder)GarnishedFluids.standardFluid("apple_cider", SolidRenderedPlaceableFluidType.create(15709047, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/apple_cider")}).build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> PEANUT_OIL = ((FluidBuilder)GarnishedFluids.standardFluid("peanut_oil", SolidRenderedPlaceableFluidType.create(13288607, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/peanut_oil")}).build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> CASHEW_MIXTURE = ((FluidBuilder)GarnishedFluids.standardFluid("cashew_mixture", SolidRenderedPlaceableFluidType.create(0xFCEFCF, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/cashew_mixture")}).build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MASTIC_RESIN = GarnishedFluids.masticResinRegistration("", 5401420);
    public static final FluidEntry<BaseFlowingFluid.Flowing> RED_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("red", 9312537);
    public static final FluidEntry<BaseFlowingFluid.Flowing> ORANGE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("orange", 10835502);
    public static final FluidEntry<BaseFlowingFluid.Flowing> YELLOW_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("yellow", 11700277);
    public static final FluidEntry<BaseFlowingFluid.Flowing> GREEN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("green", 4427305);
    public static final FluidEntry<BaseFlowingFluid.Flowing> LIME_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("lime", 3655238);
    public static final FluidEntry<BaseFlowingFluid.Flowing> BLUE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("blue", 3766910);
    public static final FluidEntry<BaseFlowingFluid.Flowing> LIGHT_BLUE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("light_blue", 5352385);
    public static final FluidEntry<BaseFlowingFluid.Flowing> CYAN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("cyan", 5357976);
    public static final FluidEntry<BaseFlowingFluid.Flowing> PURPLE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("purple", 5711001);
    public static final FluidEntry<BaseFlowingFluid.Flowing> MAGENTA_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("magenta", 10563526);
    public static final FluidEntry<BaseFlowingFluid.Flowing> PINK_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("pink", 13193357);
    public static final FluidEntry<BaseFlowingFluid.Flowing> BLACK_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("black", 398878);
    public static final FluidEntry<BaseFlowingFluid.Flowing> GRAY_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("gray", 0x2D333D);
    public static final FluidEntry<BaseFlowingFluid.Flowing> LIGHT_GRAY_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("light_gray", 7702435);
    public static final FluidEntry<BaseFlowingFluid.Flowing> WHITE_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("white", 12633312);
    public static final FluidEntry<BaseFlowingFluid.Flowing> BROWN_MASTIC_RESIN = GarnishedFluids.masticResinRegistration("brown", 6374194);
    public static final FluidEntry<BaseFlowingFluid.Flowing> DRAGON_BREATH = ((FluidBuilder)GarnishedFluids.standardFluid("dragon_breath", SolidRenderedPlaceableFluidType.create(12929155, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400).lightLevel(15)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/dragon_breath")}).build()).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> SWEET_TEA = ((FluidBuilder)GarnishedFluids.standardFluid("sweet_tea", SolidRenderedPlaceableFluidType.create(14847058, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400).lightLevel(15)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/sweet_tea")}).build()).register();

    private static ResourceLocation createLocation(String fluid, boolean isFlowing) {
        String getMotion = isFlowing ? "_flow" : "_still";
        return CreateGarnished.asResource("fluid/" + fluid + getMotion);
    }

    public static FluidBuilder<BaseFlowingFluid.Flowing, CreateRegistrate> standardFluid(String name, FluidBuilder.FluidTypeFactory typeFactory) {
        return CreateGarnished.registrate().fluid(name, GarnishedFluids.createLocation(name, false), GarnishedFluids.createLocation(name, true), typeFactory);
    }

    public static FluidEntry<BaseFlowingFluid.Flowing> masticResinRegistration(String colour0, int colour1) {
        return ((FluidBuilder)GarnishedFluids.standardFluid((String)(colour0 == "" ? colour0 : colour0 + "_") + "mastic_resin", SolidRenderedPlaceableFluidType.create(colour1, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.commonItemTag((String)"buckets/mastic_resin")}).build()).register();
    }

    public static void setRegister() {
    }

    public static void registerFluidInteractions() {
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), PEANUT_OIL.getType(), Blocks.OBSIDIAN, (Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), APPLE_CIDER.getType(), Blocks.OBSIDIAN, (Block)GarnishedPaletteStoneTypes.CARNOTITE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), GARNISH.getType(), Blocks.OBSIDIAN, (Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), CASHEW_MIXTURE.getType(), Blocks.OBSIDIAN, Blocks.END_STONE);
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.DEFAULT.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), RED_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.RED.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), ORANGE_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.ORANGE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), YELLOW_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.YELLOW.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), GREEN_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.GREEN.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), LIME_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.LIME.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), BLUE_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.BLUE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), LIGHT_BLUE_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.LIGHT_BLUE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), CYAN_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.CYAN.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), PURPLE_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.PURPLE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), MAGENTA_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.MAGENTA.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), PINK_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.PINK.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), BLACK_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.BLACK.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), GRAY_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.GRAY.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), LIGHT_GRAY_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.LIGHT_GRAY.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), WHITE_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.WHITE.getBlock().get());
        Fluids.basicFluidInteraction((FluidType)NeoForgeMod.LAVA_TYPE.value(), BROWN_MASTIC_RESIN.getType(), Blocks.OBSIDIAN, (Block)ZultaniteStoneTypes.BROWN.getBlock().get());
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluids.lavaInteraction(fluidState, (Fluid)GARNISH.get(), (Block)AllPaletteStoneTypes.CALCITE.getBaseBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)PEANUT_OIL.get(), (Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)APPLE_CIDER.get(), (Block)GarnishedPaletteStoneTypes.CARNOTITE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)CASHEW_MIXTURE.get(), Blocks.END_STONE);
        Fluids.lavaInteraction(fluidState, (Fluid)MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.DEFAULT.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)RED_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.RED.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)ORANGE_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.ORANGE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)YELLOW_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.YELLOW.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)GREEN_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.GREEN.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIME_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.LIME.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)BLUE_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.BLUE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIGHT_BLUE_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.LIGHT_BLUE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)CYAN_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.CYAN.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)PURPLE_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.PURPLE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)MAGENTA_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.MAGENTA.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)PINK_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.PINK.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)BLACK_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.BLACK.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)GRAY_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.GRAY.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)LIGHT_GRAY_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.LIGHT_GRAY.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)WHITE_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.WHITE.getBlock().get());
        Fluids.lavaInteraction(fluidState, (Fluid)BROWN_MASTIC_RESIN.get(), (Block)ZultaniteStoneTypes.BROWN.getBlock().get());
        return null;
    }

    public static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        public Vector3f fogColor;
        public Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        public SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        public int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        public Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        public float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    private static class NoColorFluidAttributes
    extends AllFluids.TintedFluidType {
        public NoColorFluidAttributes(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }
    }
}

