/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import de.darksmp.shaded.bstats.bukkit.Metrics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AnvilColor
extends JavaPlugin
implements Listener {
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacyAmpersand();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getLogger().info("AnvilColorPlugin aktiviert.");
        int pluginId = 26041;
        new Metrics(this, pluginId);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        if (event.getViewers().isEmpty() || !(event.getViewers().get(0) instanceof Player)) {
            return;
        }
        Player player = (Player)event.getViewers().get(0);
        AnvilInventory inv = event.getInventory();
        String input = inv.getRenameText();
        if (input == null || input.isEmpty()) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null) {
            return;
        }
        Component newName = this.getFormattedName(player, input);
        if (newName == null) {
            return;
        }
        result = result.clone();
        result.editMeta(meta -> meta.displayName(newName));
        event.setResult(result);
    }

    private Component getFormattedName(Player player, String input) {
        boolean allowHex = this.getConfig().getBoolean("anvil.hexcode", true);
        boolean allowColor = this.getConfig().getBoolean("anvil.colorcode", true);
        try {
            if (allowHex && !allowColor) {
                if (player.hasPermission("anvilcolor.hex") && this.containsGradient(input)) {
                    return this.miniMessage.deserialize(this.transformGradient(input));
                }
                return Component.text(input);
            }
            if (!allowHex && allowColor) {
                if (player.hasPermission("anvilcolor.color") && this.containsLegacyColor(input)) {
                    return this.legacySerializer.deserialize(input.replace("\u00a7", "&"));
                }
                return Component.text(input);
            }
            if (allowHex && allowColor) {
                if (this.containsGradient(input) && player.hasPermission("anvilcolor.hex")) {
                    return this.miniMessage.deserialize(this.transformGradient(input));
                }
                if (this.containsLegacyColor(input) && player.hasPermission("anvilcolor.color")) {
                    return this.legacySerializer.deserialize(input.replace("\u00a7", "&"));
                }
                return Component.text(input);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Fehler beim Parsen: '" + input + "' \u2013 " + e.getMessage());
        }
        return null;
    }

    private boolean containsGradient(String input) {
        return input.contains("<#") && input.contains("</#");
    }

    private boolean containsLegacyColor(String input) {
        return input.matches(".*(&|\u00a7)[0-9a-fk-or].*");
    }

    private String transformGradient(String input) {
        Pattern pattern = Pattern.compile("<#([A-Fa-f0-9]{6})>(.*?)</#([A-Fa-f0-9]{6})>");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String start = matcher.group(1);
            String middle = matcher.group(2);
            String end = matcher.group(3);
            String converted = this.convertLegacyToMiniMessage(middle);
            String replacement = "<gradient:#" + start + ":#" + end + ">" + converted + "</gradient>";
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String convertLegacyToMiniMessage(String input) {
        TextComponent comp = this.legacySerializer.deserialize(input.replace("\u00a7", "&"));
        return (String)this.miniMessage.serialize(comp);
    }
}

