/*
 * Decompiled with CFR 0.152.
 */
package de.darksmp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AnvilColor
extends JavaPlugin
implements Listener {
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacyAmpersand();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public void onEnable() {
        String version = this.getDescription().getVersion();
        this.getLogger().info("AnvilColor v" + version + " enabled.");
    }

    @EventHandler
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        if (event.getViewers().isEmpty() || !(event.getViewers().get(0) instanceof Player)) {
            return;
        }
        Player player = (Player)event.getViewers().get(0);
        AnvilInventory inv = event.getInventory();
        String input = inv.getRenameText();
        if (input == null || input.isEmpty()) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null) {
            return;
        }
        Component newName = this.parseColor(player, input);
        if (newName == null) {
            return;
        }
        result = result.clone();
        result.editMeta(meta -> meta.displayName(newName));
        event.setResult(result);
    }

    private Component parseColor(Player player, String input) {
        try {
            if (!player.hasPermission("anvilcolor.color")) {
                return null;
            }
            if (input.contains("<#") && input.contains("</#")) {
                String transformed = this.transformGradient(input);
                return this.miniMessage.deserialize((Object)transformed);
            }
            if (input.matches(".*&[0-9a-fk-or].*")) {
                return this.legacySerializer.deserialize(input.replace("\u00a7", "&"));
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Error parsing name: " + input + " | " + e.getMessage());
        }
        return null;
    }

    private String transformGradient(String input) {
        Pattern pattern = Pattern.compile("<#([A-Fa-f0-9]{6})>(.*?)</#([A-Fa-f0-9]{6})>");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String start = matcher.group(1);
            String middle = matcher.group(2);
            String end = matcher.group(3);
            String convertedText = this.convertLegacyToMiniMessage(middle);
            String replacement = "<gradient:#" + start + ":#" + end + ">" + convertedText + "</gradient>";
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String convertLegacyToMiniMessage(String input) {
        TextComponent comp = this.legacySerializer.deserialize(input.replace("\u00a7", "&"));
        return (String)MiniMessage.miniMessage().serialize((Component)comp);
    }
}

