/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.config;

import io.github.smootheez.smoothiezapi.api.Config;
import io.github.smootheez.smoothiezapi.api.ConfigApi;
import io.github.smootheez.smoothiezapi.modmenu.ModMenuApiImpl;
import io.github.smootheez.smoothiezapi.util.Constants;
import io.github.smootheez.smoothiezapi.util.ModChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ConfigManager {
    private static final Map<Class<? extends ConfigApi>, ConfigApi> configs = new HashMap<Class<? extends ConfigApi>, ConfigApi>();

    private ConfigManager() {
    }

    public static <T extends ConfigApi> void register(T configInstance) {
        Objects.requireNonNull(configInstance, "Config instance cannot be null");
        Class<?> configClass = configInstance.getClass();
        configs.putIfAbsent(configClass, configInstance);
        configInstance.loadConfig();
        configInstance.saveConfig();
        Config config = configInstance.getAnnotation(configClass);
        if (ModChecker.isModInstalled(config.name()) && ModChecker.isModInstalled("modmenu") && config.autoGui()) {
            ModMenuApiImpl.registerConfigScreen(config.name(), configInstance::getScreen);
        }
        Constants.LOGGER.info("Registered config: {}", (Object)configClass.getSimpleName());
    }

    public static <T extends ConfigApi> T getConfig(Class<T> configClass) {
        return (T)configs.get(configClass);
    }

    public static boolean isRegistered(Class<? extends ConfigApi> configClass) {
        return configs.containsKey(configClass);
    }

    public static void clearConfigs() {
        configs.clear();
    }
}

