/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.config.option;

import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.config.ConfigOptionSerializer;
import io.github.smootheez.smoothiezapi.config.serializer.EnumSerializer;
import io.github.smootheez.smoothiezapi.gui.widget.entries.handler.WidgetHandler;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EnumOption<E extends Enum<E>>
extends ConfigOption<E> {
    private final Class<E> enumClass;

    public EnumOption(String key, E defaultValue) {
        super(key, defaultValue, null, null);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
    }

    @Override
    @NotNull
    public Class<E> getType() {
        return this.enumClass;
    }

    @Override
    @NotNull
    public WidgetHandler<E> getWidgetHandler() {
        return new WidgetHandler.EnumHandler();
    }

    @Override
    @NotNull
    public ConfigOptionSerializer<E> getSerializer() {
        return new EnumSerializer<E>(this.enumClass);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumOption that = (EnumOption)o;
        return Objects.equals(this.enumClass, that.enumClass);
    }

    public int hashCode() {
        return Objects.hashCode(this.enumClass);
    }
}

