/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.screen;

import com.google.common.collect.Lists;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.config.OptionList;
import io.github.smootheez.smoothiezapi.gui.widget.entries.OptionListWidgetEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class OptionListScreen
extends class_437 {
    public static final String SCREEN = "screen.";
    private final class_437 parent;
    private final OptionListWidgetEntry widgetEntry;
    private final class_8132 layout = new class_8132((class_437)this, 50, 30);
    private WidgetContainer widgetContainer;
    private class_342 editBox;

    public OptionListScreen(class_437 parent, OptionListWidgetEntry widgetEntry) {
        super((class_2561)class_2561.method_43471((String)"screen.smoothiezapi.option_list.title"));
        this.parent = parent;
        this.widgetEntry = widgetEntry;
    }

    protected void method_25426() {
        this.widgetContainer = new WidgetContainer();
        class_8667 headerLayout = (class_8667)this.layout.method_48992((class_8021)class_8667.method_52741().method_52735(4));
        headerLayout.method_52740().method_46467();
        headerLayout.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        this.editBox = new class_342(this.field_22793, this.layout.method_25368() / 2 - 100, 22, 200, 20, (class_2561)class_2561.method_43470((String)""));
        this.editBox.method_1863(this.widgetContainer::filter);
        headerLayout.method_52736((class_8021)this.editBox);
        class_8667 footerLayout = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(4));
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46431());
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"widget.smoothiezapi.add.option_list"), btn -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new EditOrAddValueScreen(this, ScreenActionType.ADD, ""));
            }
        }).method_46431());
        this.method_37063((class_364)this.widgetContainer);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    protected void method_56131() {
        if (this.editBox != null) {
            this.method_48265((class_364)this.editBox);
        }
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.widgetContainer != null) {
            this.widgetContainer.method_73369(this.layout.method_25368(), this.layout.method_57727(), 0, this.layout.method_48998());
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class WidgetContainer
    extends class_4265<WidgetEntry> {
        private final ConfigOption<OptionList> option;
        private String filter;

        public WidgetContainer() {
            super(OptionListScreen.this.field_22787, OptionListScreen.this.layout.method_25368(), OptionListScreen.this.layout.method_57727(), OptionListScreen.this.layout.method_48998(), 24);
            this.filter = "";
            this.option = OptionListScreen.this.widgetEntry.getOption();
            this.refreshEntries();
            this.method_44382(this.method_44387());
        }

        public void filter(String search) {
            this.filter = search == null ? "" : search.trim();
            this.refreshEntries();
        }

        public void removeValue(String value) {
            OptionList optionList = this.option.getValue();
            optionList.remove(value);
            OptionListScreen.this.widgetEntry.setOptionValue(optionList);
            this.refreshEntries();
        }

        private void refreshEntries() {
            this.method_25339();
            this.option.getValue().values().stream().filter((? super T value) -> value.toLowerCase(Locale.ROOT).contains(this.filter.toLowerCase(Locale.ROOT))).forEach(value -> this.method_25321((class_350.class_351)new WidgetEntry((String)value)));
            this.method_44382(0.0);
        }

        public int method_25322() {
            return this.method_44392() ? this.method_25368() - 20 : this.method_25368() - 12;
        }

        public int method_25342() {
            return 6;
        }

        protected int method_65507() {
            return this.method_55442() - 12;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class EditOrAddValueScreen
    extends class_437 {
        private final class_437 parent;
        private final String label;
        private final ScreenActionType type;
        private OptionList optionList;
        private class_342 editBox;

        protected EditOrAddValueScreen(class_437 parent, ScreenActionType type, String label) {
            super(type.getComponent());
            this.parent = parent;
            this.label = label;
            this.type = type;
        }

        protected void method_25426() {
            this.optionList = OptionListScreen.this.widgetEntry.getOption().getValue();
            this.editBox = new class_342(this.field_22793, this.field_22789 / 2 - 75, this.field_22790 / 2 - 50, 150, 20, (class_2561)class_2561.method_43470((String)""));
            this.editBox.method_1852(this.label);
            this.method_37063((class_364)this.editBox);
            class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.updateOptionValue()).method_46431();
            doneButton.method_48229(this.field_22789 / 2 - doneButton.method_25368() / 2, this.field_22790 / 2 - 12);
            this.method_37063((class_364)doneButton);
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, btn -> this.method_25419()).method_46431();
            cancelButton.method_48229(this.field_22789 / 2 - cancelButton.method_25368() / 2, this.field_22790 / 2 + 12);
            this.method_37063((class_364)cancelButton);
        }

        private void updateOptionValue() {
            String newValue = this.editBox.method_1882().trim();
            if (newValue.isEmpty() || newValue.equals(this.label)) {
                this.method_25419();
                return;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    this.optionList.edit(this.label, newValue);
                    break;
                }
                case 1: {
                    this.optionList.add(newValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.type));
                }
            }
            OptionListScreen.this.widgetEntry.setOptionValue(this.optionList);
            OptionListScreen.this.widgetContainer.refreshEntries();
            this.method_25419();
        }

        public void method_25419() {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
                OptionListScreen.this.widgetContainer.refreshEntries();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum ScreenActionType {
        EDIT((class_2561)class_2561.method_43471((String)"screen.smoothiezapi.edit.title")),
        ADD((class_2561)class_2561.method_43471((String)"screen.smoothiezapi.add.title"));

        private final class_2561 component;

        private ScreenActionType(class_2561 component) {
            this.component = component;
        }

        public class_2561 getComponent() {
            return this.component;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class WidgetEntry
    extends class_4265.class_4266<WidgetEntry> {
        private final String label;
        private final class_7842 labelWidget;
        protected final List<class_339> children = Lists.newArrayList();
        protected final List<class_339> rightAlignedWidget = new ArrayList<class_339>();
        private static final int H_PADDING = 1;
        private static final int V_CENTER_OFFSET = 0;
        private static final int SPACING = 3;

        public WidgetEntry(String label) {
            this.label = label;
            this.labelWidget = new class_7842((class_2561)class_2561.method_43470((String)this.label), OptionListScreen.this.field_22793);
            this.addChild((class_339)this.labelWidget);
            this.addRightAlignedWidget((class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), button -> OptionListScreen.this.widgetContainer.removeValue(label)).method_46437(20, 20).method_46431());
            this.addRightAlignedWidget((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"widget.smoothiezapi.edit.option_list"), this::onPress).method_46437(80, 20).method_46431());
        }

        protected void addChild(class_339 widget) {
            this.children.add(widget);
        }

        protected void addRightAlignedWidget(class_339 widget) {
            this.addChild(widget);
            this.rightAlignedWidget.add(widget);
        }

        private int layoutRightAlignedWidgets(List<? extends class_339> widgets) {
            int contentRight = this.method_73389() - 1;
            int centerY = this.method_73385() + 0;
            int nextX = contentRight;
            for (class_339 class_3392 : widgets) {
                class_3392.method_48229(nextX -= class_3392.method_25368(), centerY - class_3392.method_25364() / 2);
                nextX -= 3;
            }
            return nextX;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
            int contentX = this.method_73380();
            guiGraphics.method_25294(contentX - 1, this.method_73382() - 1, this.method_73389() + 1, this.method_73386() + 1, Integer.MIN_VALUE);
            int leftBoundary = this.layoutRightAlignedWidgets(this.rightAlignedWidget);
            this.labelWidget.method_73395(leftBoundary - contentX - 1, class_7842.class_11764.field_62127);
            this.labelWidget.method_48229(contentX + 1 + 2, this.method_73385() - this.labelWidget.method_25364() / 2);
            this.labelWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
            for (class_339 widget : this.rightAlignedWidget) {
                widget.method_25394(guiGraphics, mouseX, mouseY, delta);
            }
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        private void onPress(class_4185 button) {
            if (OptionListScreen.this.field_22787 != null) {
                OptionListScreen.this.field_22787.method_1507((class_437)new EditOrAddValueScreen(OptionListScreen.this, ScreenActionType.EDIT, this.label));
            }
        }
    }
}

