/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.widget.entries.container;

import io.github.smootheez.smoothiezapi.api.ConfigApi;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.gui.helper.ConfigTranslationHelper;
import io.github.smootheez.smoothiezapi.gui.widget.base.ConfigWidgetEntry;
import io.github.smootheez.smoothiezapi.util.DebugMode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8132;

@Environment(value=EnvType.CLIENT)
public class ConfigWidgetContainer
extends class_4265<ConfigWidgetEntry> {
    private final int layoutWidth;
    private final String configId;
    private final List<ConfigOption<?>> allConfigOptions;
    private String filter = "";

    public ConfigWidgetContainer(class_310 minecraft, class_8132 layout, ConfigApi configApi) {
        super(minecraft, layout.method_25368(), layout.method_57727(), layout.method_48998(), 24);
        this.layoutWidth = layout.method_25368();
        this.configId = configApi.getConfigId();
        this.allConfigOptions = configApi.getAllConfigOptions();
        this.refreshEntries();
        this.method_44382(this.method_44387());
    }

    public void filter(String search) {
        this.filter = search == null ? "" : search.trim();
        this.refreshEntries();
    }

    private void refreshEntries() {
        this.method_25339();
        this.allConfigOptions.stream().filter((? super T option) -> this.matchesSearchTerm((ConfigOption<?>)option, this.filter)).forEach(option -> this.method_25321((class_350.class_351)this.createWidget((ConfigOption)option)));
        this.method_44382(0.0);
    }

    private boolean matchesSearchTerm(ConfigOption<?> option, String search) {
        if (search.isEmpty()) {
            return true;
        }
        String query = search.toLowerCase(Locale.ROOT);
        String translationKey = ConfigTranslationHelper.getTranslationKey(this.configId, option.getKey());
        String displayText = class_1074.method_4663((String)translationKey) ? class_1074.method_4662((String)translationKey, (Object[])new Object[0]).toLowerCase(Locale.ROOT) : option.getKey().toLowerCase(Locale.ROOT);
        return displayText.contains(query);
    }

    public <T> ConfigWidgetEntry createWidget(ConfigOption<T> option) {
        DebugMode.sendLogInfo("Creating widget for option: " + option.getKey() + " with type: " + option.getType().getSimpleName());
        return option.getWidgetHandler().createWidget(option, this.configId, this.createTooltip(option));
    }

    private List<class_5481> createTooltip(ConfigOption<?> option) {
        String tooltipKey = ConfigTranslationHelper.getDescriptionTranslationKey(this.configId, option.getKey());
        if (!class_1074.method_4663((String)tooltipKey)) {
            return Collections.emptyList();
        }
        class_5250 tooltipComponent = class_2561.method_43471((String)tooltipKey);
        return this.field_22740.field_1772.method_1728((class_5348)tooltipComponent, this.layoutWidth / 2);
    }

    public int method_25322() {
        return this.method_25368() - (this.method_44392() ? 20 : 12);
    }

    public int method_25342() {
        return 6;
    }

    protected int method_65507() {
        return this.method_55442() - 12;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        ConfigWidgetEntry hovered = (ConfigWidgetEntry)this.method_37019();
        if (hovered != null && hovered.tooltip != null) {
            guiGraphics.method_71274(hovered.tooltip, mouseX, mouseY);
        }
    }
}

