/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.api;

import io.github.smootheez.smoothiezapi.api.Config;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.config.ConfigWriter;
import io.github.smootheez.smoothiezapi.gui.screen.ConfigScreen;
import io.github.smootheez.smoothiezapi.util.Constants;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_437;

public interface ConfigApi {
    default public String getConfigId() {
        Config config = this.getAnnotation(this.getClass());
        return config.name();
    }

    default public Config getAnnotation(Class<? extends ConfigApi> clazz) {
        Config annotation = clazz.getAnnotation(Config.class);
        if (annotation == null) {
            throw new IllegalStateException("Config class " + clazz.getName() + " is missing @Config annotation");
        }
        return annotation;
    }

    default public List<ConfigOption<?>> getAllConfigOptions() {
        ArrayList options = new ArrayList();
        Arrays.stream(this.getClass().getMethods()).filter(method -> ConfigOption.class.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 0).forEach(method -> this.invokeConfigOption((Method)method, options));
        return options;
    }

    default public ConfigWriter getWriter() {
        ConfigWriter writer = new ConfigWriter(this.getConfigId());
        this.getAllConfigOptions().forEach(option -> writer.addOption(option.getKey(), option));
        return writer;
    }

    private void invokeConfigOption(Method method, List<ConfigOption<?>> options) {
        try {
            Object value = method.invoke((Object)this, new Object[0]);
            if (value instanceof ConfigOption) {
                ConfigOption option = (ConfigOption)value;
                options.add(option);
            }
        }
        catch (ReflectiveOperationException e) {
            Constants.LOGGER.error("Failed to get config option from method {}: {}", (Object)method.getName(), (Object)e.getMessage());
        }
    }

    default public void saveConfig() {
        this.getWriter().saveConfig();
    }

    default public void loadConfig() {
        this.getWriter().loadConfig();
    }

    default public class_437 getScreen(class_437 parent) {
        return new ConfigScreen(parent, this);
    }
}

