/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.widget.base;

import com.google.common.collect.Lists;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.gui.widget.base.ConfigWidgetEntry;
import io.github.smootheez.smoothiezapi.util.DebugMode;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class LabeledWidgetEntry<T>
extends ConfigWidgetEntry {
    protected final ConfigOption<T> option;
    protected final List<class_339> children = Lists.newArrayList();
    protected final List<class_339> rightAlignedWidget = new ArrayList<class_339>();
    protected final class_7842 labelWidget;
    private final class_4185 resetButton;
    private static final int H_PADDING = 1;
    private static final int V_CENTER_OFFSET = 0;
    private static final int SPACING = 3;

    protected LabeledWidgetEntry(String label, @Nullable List<class_5481> description, ConfigOption<T> option) {
        super(description);
        this.option = option;
        this.labelWidget = new class_7842((class_2561)class_2561.method_43471((String)label), class_310.method_1551().field_1772);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b6e"), button -> this.resetButtonAction()).method_46437(20, 20).method_46431();
        this.addChild((class_339)this.labelWidget);
        this.addRightAlignedWidget((class_339)this.resetButton);
        this.updateResetButtonState();
    }

    public void setOptionValue(T value) {
        this.option.setValue(value);
        this.updateResetButtonState();
        DebugMode.sendLogInfo("Option " + this.option.getKey() + " changed to: " + String.valueOf(value));
    }

    protected void addChild(class_339 widget) {
        this.children.add(widget);
    }

    protected void addRightAlignedWidget(class_339 widget) {
        this.addChild(widget);
        this.rightAlignedWidget.add(widget);
    }

    public boolean isDefaultValue() {
        T currentValue = this.option.getValue();
        T defaultValue = this.option.getDefaultValue();
        boolean isEquals = currentValue.equals(defaultValue);
        DebugMode.sendLogInfo("Current value: " + String.valueOf(currentValue) + ", Default value: " + String.valueOf(defaultValue) + ", Are they equal? " + isEquals);
        return isEquals;
    }

    private void resetButtonAction() {
        this.option.setValue(this.option.getDefaultValue());
        this.updateWidgetState();
        this.updateResetButtonState();
        DebugMode.sendLogInfo("Resetting option " + this.option.getKey() + " to default value: " + String.valueOf(this.option.getDefaultValue()));
    }

    private void updateResetButtonState() {
        this.resetButton.field_22763 = !this.isDefaultValue();
    }

    protected void updateWidgetState() {
    }

    public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        int contentX = this.method_73380();
        guiGraphics.method_25294(contentX - 1, this.method_73382() - 1, this.method_73389() + 1, this.method_73386() + 1, Integer.MIN_VALUE);
        int leftBoundary = this.layoutRightAlignedWidgets(this.rightAlignedWidget);
        this.labelWidget.method_73395(leftBoundary - contentX - 1, class_7842.class_11764.field_62127);
        this.labelWidget.method_48229(contentX + 1 + 2, this.method_73385() - this.labelWidget.method_25364() / 2);
        this.labelWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
        for (class_339 widget : this.rightAlignedWidget) {
            widget.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
    }

    private int layoutRightAlignedWidgets(List<? extends class_339> widgets) {
        int contentRight = this.method_73389() - 1;
        int centerY = this.method_73385() + 0;
        int nextX = contentRight;
        for (class_339 class_3392 : widgets) {
            class_3392.method_48229(nextX -= class_3392.method_25368(), centerY - class_3392.method_25364() / 2);
            nextX -= 3;
        }
        return nextX;
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        return this.children;
    }
}

