/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.config;

import io.github.smootheez.smoothiezapi.config.ConfigOptionSerializer;
import io.github.smootheez.smoothiezapi.gui.widget.entries.handler.WidgetHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigOption<T> {
    private final String key;
    private T value;
    private final T minValue;
    private final T maxValue;
    private final T defaultValue;

    protected ConfigOption(String key, T defaultValue, T minValue, T maxValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    @NotNull
    public abstract Class<T> getType();

    @NotNull
    public abstract WidgetHandler<T> getWidgetHandler();

    @NotNull
    public abstract ConfigOptionSerializer<T> getSerializer();

    protected static void trhowIllegalArgumentException() {
        throw new IllegalArgumentException("minValue cannot be greater than maxValue");
    }
}

