/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.util.Constants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigWriter {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;
    private final Map<String, ConfigOptionAdpter<?>> options;

    public ConfigWriter(String configId) {
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve(configId + ".json").toFile();
        this.options = new TreeMap();
    }

    public <T> void addOption(String key, ConfigOption<T> option) {
        this.options.putIfAbsent(key, new ConfigOptionAdpter<T>(option));
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            JsonElement element = (JsonElement)this.gson.fromJson((Reader)reader, JsonElement.class);
            this.fromJson(element);
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to load config file: {}, error: {}", (Object)this.configFile.getAbsoluteFile(), (Object)e.getMessage());
        }
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            JsonElement element = this.toJson();
            this.gson.toJson(element, (Appendable)writer);
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to save config file: {}, error: {}", (Object)this.configFile.getAbsoluteFile(), (Object)e.getMessage());
        }
    }

    private void fromJson(JsonElement element) {
        this.options.forEach((key, adpter) -> {
            JsonElement jsonElement = element.getAsJsonObject().get(key);
            if (jsonElement != null) {
                adpter.fromJson(jsonElement);
            }
        });
    }

    private JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        this.options.forEach((key, adpter) -> jsonObject.add(key, adpter.toJson()));
        return jsonObject;
    }

    record ConfigOptionAdpter<T>(ConfigOption<T> option) {
        void fromJson(JsonElement element) {
            this.option.setValue(this.option.getSerializer().deserialize(element));
        }

        JsonElement toJson() {
            return this.option.getSerializer().serialize(this.option.getValue());
        }
    }
}

