/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.overlay;

import io.github.smootheez.smoothiezapi.gui.overlay.ElementAnchor;
import io.github.smootheez.smoothiezapi.gui.overlay.ElementDirection;
import io.github.smootheez.smoothiezapi.gui.overlay.OverlayElement;
import io.github.smootheez.smoothiezapi.gui.overlay.PositionedElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public record ElementLayoutEngine(List<OverlayElement> elements, ElementAnchor anchor, ElementDirection direction, int spacing, int margin) {
    public List<PositionedElement> layout(int anchorX, int anchorY) {
        Size size = this.computeTotalSize();
        Point adjusted = this.applyAnchorAdjustment(anchorX, anchorY, size.totalWidth(), size.totalHeight());
        return this.placeElements(adjusted.x(), adjusted.y());
    }

    public void renderLayout(GuiGraphics guiGraphics, List<PositionedElement> elements) {
        for (PositionedElement p : elements) {
            p.element().renderer().render(guiGraphics, p.x(), p.y());
        }
    }

    private Size computeTotalSize() {
        int totalWidth = 0;
        int totalHeight = 0;
        if (this.direction == ElementDirection.HORIZONTAL) {
            for (OverlayElement e : this.elements) {
                totalWidth += e.width();
            }
            totalWidth += (this.elements.size() - 1) * this.spacing;
            totalHeight = this.elements.stream().mapToInt(OverlayElement::height).max().orElse(0);
        } else {
            for (OverlayElement e : this.elements) {
                totalHeight += e.height();
            }
            totalHeight += (this.elements.size() - 1) * this.spacing;
            totalWidth = this.elements.stream().mapToInt(OverlayElement::width).max().orElse(0);
        }
        return new Size(totalWidth, totalHeight);
    }

    private Point applyAnchorAdjustment(int anchorX, int anchorY, int totalWidth, int totalHeight) {
        anchorX = switch (this.anchor) {
            default -> throw new MatchException(null, null);
            case ElementAnchor.START -> anchorX + this.margin;
            case ElementAnchor.MIDDLE -> anchorX - totalWidth / 2;
            case ElementAnchor.END -> anchorX - (totalWidth + this.margin);
        };
        anchorY = switch (this.anchor) {
            default -> throw new MatchException(null, null);
            case ElementAnchor.START -> anchorY + this.margin;
            case ElementAnchor.MIDDLE -> anchorY - totalHeight / 2;
            case ElementAnchor.END -> anchorY - (totalHeight + this.margin);
        };
        return new Point(anchorX, anchorY);
    }

    private List<PositionedElement> placeElements(int startX, int startY) {
        ArrayList<PositionedElement> result = new ArrayList<PositionedElement>();
        int currentX = startX;
        int currentY = startY;
        for (OverlayElement element : this.elements) {
            result.add(new PositionedElement(currentX, currentY, element));
            if (this.direction == ElementDirection.HORIZONTAL) {
                currentX += element.width() + this.spacing;
                continue;
            }
            currentY += element.height() + this.spacing;
        }
        return result;
    }

    private record Size(int totalWidth, int totalHeight) {
    }

    private record Point(int x, int y) {
    }
}

