/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.screen;

import io.github.smootheez.smoothiezapi.api.ConfigApi;
import io.github.smootheez.smoothiezapi.gui.widget.entries.container.ConfigWidgetContainer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends Screen {
    private final Screen parent;
    private final ConfigApi configApi;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 50, 30);
    private ConfigWidgetContainer configWidgetContainer;
    private EditBox searchBox;

    public ConfigScreen(Screen parent, ConfigApi configApi) {
        super((Component)Component.translatable((String)("config.screen." + configApi.getConfigId() + ".title")));
        this.parent = parent;
        this.configApi = configApi;
    }

    protected void init() {
        this.configWidgetContainer = new ConfigWidgetContainer(this.minecraft, this.layout, this.configApi);
        LinearLayout headerLayout = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(4));
        headerLayout.defaultCellSetting().alignHorizontallyCenter();
        headerLayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
        this.searchBox = new EditBox(this.font, this.layout.getWidth() / 2 - 100, 22, 200, 20, (Component)Component.literal((String)""));
        this.searchBox.setResponder(this.configWidgetContainer::filter);
        headerLayout.addChild((LayoutElement)this.searchBox);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        this.addRenderableWidget((GuiEventListener)this.configWidgetContainer);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    protected void setInitialFocus() {
        if (this.searchBox != null) {
            this.setInitialFocus((GuiEventListener)this.searchBox);
        }
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.configWidgetContainer != null) {
            this.configWidgetContainer.updateSizeAndPosition(this.layout.getWidth(), this.layout.getContentHeight(), 0, this.layout.getHeaderHeight());
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.configApi.saveConfig();
            this.minecraft.setScreen(this.parent);
        }
    }
}

