/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.screen;

import com.google.common.collect.Lists;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.config.OptionList;
import io.github.smootheez.smoothiezapi.gui.widget.entries.OptionListWidgetEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class OptionListScreen
extends Screen {
    public static final String SCREEN = "screen.";
    private final Screen parent;
    private final OptionListWidgetEntry widgetEntry;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 50, 30);
    private WidgetContainer widgetContainer;
    private EditBox editBox;

    public OptionListScreen(Screen parent, OptionListWidgetEntry widgetEntry) {
        super((Component)Component.translatable((String)"screen.smoothiezapi.option_list.title"));
        this.parent = parent;
        this.widgetEntry = widgetEntry;
    }

    protected void init() {
        this.widgetContainer = new WidgetContainer();
        LinearLayout headerLayout = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(4));
        headerLayout.defaultCellSetting().alignHorizontallyCenter();
        headerLayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
        this.editBox = new EditBox(this.font, this.layout.getWidth() / 2 - 100, 22, 200, 20, (Component)Component.literal((String)""));
        this.editBox.setResponder(this.widgetContainer::filter);
        headerLayout.addChild((LayoutElement)this.editBox);
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(4));
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"widget.smoothiezapi.add.option_list"), btn -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new EditOrAddValueScreen(this, ScreenActionType.ADD, ""));
            }
        }).build());
        this.addRenderableWidget((GuiEventListener)this.widgetContainer);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void setInitialFocus() {
        if (this.editBox != null) {
            this.setInitialFocus((GuiEventListener)this.editBox);
        }
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.widgetContainer != null) {
            this.widgetContainer.updateSizeAndPosition(this.layout.getWidth(), this.layout.getContentHeight(), 0, this.layout.getHeaderHeight());
        }
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class WidgetContainer
    extends ContainerObjectSelectionList<WidgetEntry> {
        private final ConfigOption<OptionList> option;
        private String filter;

        public WidgetContainer() {
            super(OptionListScreen.this.minecraft, OptionListScreen.this.layout.getWidth(), OptionListScreen.this.layout.getContentHeight(), OptionListScreen.this.layout.getHeaderHeight(), 24);
            this.filter = "";
            this.option = OptionListScreen.this.widgetEntry.getOption();
            this.refreshEntries();
            this.setScrollAmount(this.scrollAmount());
        }

        public void filter(String search) {
            this.filter = search == null ? "" : search.trim();
            this.refreshEntries();
        }

        public void removeValue(String value) {
            OptionList optionList = this.option.getValue();
            optionList.remove(value);
            OptionListScreen.this.widgetEntry.setOptionValue(optionList);
            this.refreshEntries();
        }

        private void refreshEntries() {
            this.clearEntries();
            this.option.getValue().values().stream().filter((? super T value) -> value.toLowerCase(Locale.ROOT).contains(this.filter.toLowerCase(Locale.ROOT))).forEach(value -> this.addEntry((AbstractSelectionList.Entry)new WidgetEntry((String)value)));
            this.setScrollAmount(0.0);
        }

        public int getRowWidth() {
            return this.scrollbarVisible() ? this.getWidth() - 20 : this.getWidth() - 12;
        }

        public int getRowLeft() {
            return 6;
        }

        protected int scrollBarX() {
            return this.getRight() - 12;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class EditOrAddValueScreen
    extends Screen {
        private final Screen parent;
        private final String label;
        private final ScreenActionType type;
        private OptionList optionList;
        private EditBox editBox;

        protected EditOrAddValueScreen(Screen parent, ScreenActionType type, String label) {
            super(type.getComponent());
            this.parent = parent;
            this.label = label;
            this.type = type;
        }

        protected void init() {
            this.optionList = OptionListScreen.this.widgetEntry.getOption().getValue();
            this.editBox = new EditBox(this.font, this.width / 2 - 75, this.height / 2 - 50, 150, 20, (Component)Component.literal((String)""));
            this.editBox.setValue(this.label);
            this.addRenderableWidget((GuiEventListener)this.editBox);
            Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.updateOptionValue()).build();
            doneButton.setPosition(this.width / 2 - doneButton.getWidth() / 2, this.height / 2 - 12);
            this.addRenderableWidget((GuiEventListener)doneButton);
            Button cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, btn -> this.onClose()).build();
            cancelButton.setPosition(this.width / 2 - cancelButton.getWidth() / 2, this.height / 2 + 12);
            this.addRenderableWidget((GuiEventListener)cancelButton);
        }

        private void updateOptionValue() {
            String newValue = this.editBox.getValue().trim();
            if (newValue.isEmpty() || newValue.equals(this.label)) {
                this.onClose();
                return;
            }
            switch (this.type.ordinal()) {
                case 0: {
                    this.optionList.edit(this.label, newValue);
                    break;
                }
                case 1: {
                    this.optionList.add(newValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.type));
                }
            }
            OptionListScreen.this.widgetEntry.setOptionValue(this.optionList);
            OptionListScreen.this.widgetContainer.refreshEntries();
            this.onClose();
        }

        public void onClose() {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
                OptionListScreen.this.widgetContainer.refreshEntries();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static enum ScreenActionType {
        EDIT((Component)Component.translatable((String)"screen.smoothiezapi.edit.title")),
        ADD((Component)Component.translatable((String)"screen.smoothiezapi.add.title"));

        private final Component component;

        private ScreenActionType(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class WidgetEntry
    extends ContainerObjectSelectionList.Entry<WidgetEntry> {
        private final String label;
        private final StringWidget labelWidget;
        protected final List<AbstractWidget> children = Lists.newArrayList();
        protected final List<AbstractWidget> rightAlignedWidget = new ArrayList<AbstractWidget>();
        private static final int H_PADDING = 1;
        private static final int V_CENTER_OFFSET = 0;
        private static final int SPACING = 3;

        public WidgetEntry(String label) {
            this.label = label;
            this.labelWidget = new StringWidget((Component)Component.literal((String)this.label), OptionListScreen.this.font);
            this.addChild((AbstractWidget)this.labelWidget);
            this.addRightAlignedWidget((AbstractWidget)Button.builder((Component)Component.literal((String)"\u274c"), button -> OptionListScreen.this.widgetContainer.removeValue(label)).size(20, 20).build());
            this.addRightAlignedWidget((AbstractWidget)Button.builder((Component)Component.translatable((String)"widget.smoothiezapi.edit.option_list"), this::onPress).size(80, 20).build());
        }

        protected void addChild(AbstractWidget widget) {
            this.children.add(widget);
        }

        protected void addRightAlignedWidget(AbstractWidget widget) {
            this.addChild(widget);
            this.rightAlignedWidget.add(widget);
        }

        private int layoutRightAlignedWidgets(List<? extends AbstractWidget> widgets) {
            int contentRight = this.getContentRight() - 1;
            int centerY = this.getContentYMiddle() + 0;
            int nextX = contentRight;
            for (AbstractWidget abstractWidget : widgets) {
                abstractWidget.setPosition(nextX -= abstractWidget.getWidth(), centerY - abstractWidget.getHeight() / 2);
                nextX -= 3;
            }
            return nextX;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
            int contentX = this.getContentX();
            guiGraphics.fill(contentX - 1, this.getContentY() - 1, this.getContentRight() + 1, this.getContentBottom() + 1, Integer.MIN_VALUE);
            int leftBoundary = this.layoutRightAlignedWidgets(this.rightAlignedWidget);
            this.labelWidget.setMaxWidth(leftBoundary - contentX - 1, StringWidget.TextOverflow.SCROLLING);
            this.labelWidget.setPosition(contentX + 1 + 2, this.getContentYMiddle() - this.labelWidget.getHeight() / 2);
            this.labelWidget.render(guiGraphics, mouseX, mouseY, delta);
            for (AbstractWidget widget : this.rightAlignedWidget) {
                widget.render(guiGraphics, mouseX, mouseY, delta);
            }
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        private void onPress(Button button) {
            if (OptionListScreen.this.minecraft != null) {
                OptionListScreen.this.minecraft.setScreen((Screen)new EditOrAddValueScreen(OptionListScreen.this, ScreenActionType.EDIT, this.label));
            }
        }
    }
}

