/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.widget.base;

import com.google.common.collect.Lists;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.gui.widget.base.ConfigWidgetEntry;
import io.github.smootheez.smoothiezapi.util.DebugMode;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class LabeledWidgetEntry<T>
extends ConfigWidgetEntry {
    protected final ConfigOption<T> option;
    protected final List<AbstractWidget> children = Lists.newArrayList();
    protected final List<AbstractWidget> rightAlignedWidget = new ArrayList<AbstractWidget>();
    protected final StringWidget labelWidget;
    private final Button resetButton;
    private static final int H_PADDING = 1;
    private static final int V_CENTER_OFFSET = 0;
    private static final int SPACING = 3;

    protected LabeledWidgetEntry(String label, @Nullable List<FormattedCharSequence> description, ConfigOption<T> option) {
        super(description);
        this.option = option;
        this.labelWidget = new StringWidget((Component)Component.translatable((String)label), Minecraft.getInstance().font);
        this.resetButton = Button.builder((Component)Component.literal((String)"\u2b6e"), button -> this.resetButtonAction()).size(20, 20).build();
        this.addChild((AbstractWidget)this.labelWidget);
        this.addRightAlignedWidget((AbstractWidget)this.resetButton);
        this.updateResetButtonState();
    }

    public void setOptionValue(T value) {
        this.option.setValue(value);
        this.updateResetButtonState();
        DebugMode.sendLogInfo("Option " + this.option.getKey() + " changed to: " + String.valueOf(value));
    }

    protected void addChild(AbstractWidget widget) {
        this.children.add(widget);
    }

    protected void addRightAlignedWidget(AbstractWidget widget) {
        this.addChild(widget);
        this.rightAlignedWidget.add(widget);
    }

    public boolean isDefaultValue() {
        T currentValue = this.option.getValue();
        T defaultValue = this.option.getDefaultValue();
        boolean isEquals = currentValue.equals(defaultValue);
        DebugMode.sendLogInfo("Current value: " + String.valueOf(currentValue) + ", Default value: " + String.valueOf(defaultValue) + ", Are they equal? " + isEquals);
        return isEquals;
    }

    private void resetButtonAction() {
        this.option.setValue(this.option.getDefaultValue());
        this.updateWidgetState();
        this.updateResetButtonState();
        DebugMode.sendLogInfo("Resetting option " + this.option.getKey() + " to default value: " + String.valueOf(this.option.getDefaultValue()));
    }

    private void updateResetButtonState() {
        this.resetButton.active = !this.isDefaultValue();
    }

    protected void updateWidgetState() {
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        int contentX = this.getContentX();
        guiGraphics.fill(contentX - 1, this.getContentY() - 1, this.getContentRight() + 1, this.getContentBottom() + 1, Integer.MIN_VALUE);
        int leftBoundary = this.layoutRightAlignedWidgets(this.rightAlignedWidget);
        this.labelWidget.setMaxWidth(leftBoundary - contentX - 1, StringWidget.TextOverflow.SCROLLING);
        this.labelWidget.setPosition(contentX + 1 + 2, this.getContentYMiddle() - this.labelWidget.getHeight() / 2);
        this.labelWidget.render(guiGraphics, mouseX, mouseY, delta);
        for (AbstractWidget widget : this.rightAlignedWidget) {
            widget.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    private int layoutRightAlignedWidgets(List<? extends AbstractWidget> widgets) {
        int contentRight = this.getContentRight() - 1;
        int centerY = this.getContentYMiddle() + 0;
        int nextX = contentRight;
        for (AbstractWidget abstractWidget : widgets) {
            abstractWidget.setPosition(nextX -= abstractWidget.getWidth(), centerY - abstractWidget.getHeight() / 2);
            nextX -= 3;
        }
        return nextX;
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return this.children;
    }
}

