/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.widget.entries.container;

import io.github.smootheez.smoothiezapi.api.ConfigApi;
import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.gui.helper.ConfigTranslationHelper;
import io.github.smootheez.smoothiezapi.gui.widget.base.ConfigWidgetEntry;
import io.github.smootheez.smoothiezapi.util.DebugMode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

@Environment(value=EnvType.CLIENT)
public class ConfigWidgetContainer
extends ContainerObjectSelectionList<ConfigWidgetEntry> {
    private final int layoutWidth;
    private final String configId;
    private final List<ConfigOption<?>> allConfigOptions;
    private String filter = "";

    public ConfigWidgetContainer(Minecraft minecraft, HeaderAndFooterLayout layout, ConfigApi configApi) {
        super(minecraft, layout.getWidth(), layout.getContentHeight(), layout.getHeaderHeight(), 24);
        this.layoutWidth = layout.getWidth();
        this.configId = configApi.getConfigId();
        this.allConfigOptions = configApi.getAllConfigOptions();
        this.refreshEntries();
        this.setScrollAmount(this.scrollAmount());
    }

    public void filter(String search) {
        this.filter = search == null ? "" : search.trim();
        this.refreshEntries();
    }

    private void refreshEntries() {
        this.clearEntries();
        this.allConfigOptions.stream().filter((? super T option) -> this.matchesSearchTerm((ConfigOption<?>)option, this.filter)).forEach(option -> this.addEntry((AbstractSelectionList.Entry)this.createWidget((ConfigOption)option)));
        this.setScrollAmount(0.0);
    }

    private boolean matchesSearchTerm(ConfigOption<?> option, String search) {
        if (search.isEmpty()) {
            return true;
        }
        String query = search.toLowerCase(Locale.ROOT);
        String translationKey = ConfigTranslationHelper.getTranslationKey(this.configId, option.getKey());
        String displayText = I18n.exists((String)translationKey) ? I18n.get((String)translationKey, (Object[])new Object[0]).toLowerCase(Locale.ROOT) : option.getKey().toLowerCase(Locale.ROOT);
        return displayText.contains(query);
    }

    public <T> ConfigWidgetEntry createWidget(ConfigOption<T> option) {
        DebugMode.sendLogInfo("Creating widget for option: " + option.getKey() + " with type: " + option.getType().getSimpleName());
        return option.getWidgetHandler().createWidget(option, this.configId, this.createTooltip(option));
    }

    private List<FormattedCharSequence> createTooltip(ConfigOption<?> option) {
        String tooltipKey = ConfigTranslationHelper.getDescriptionTranslationKey(this.configId, option.getKey());
        if (!I18n.exists((String)tooltipKey)) {
            return Collections.emptyList();
        }
        MutableComponent tooltipComponent = Component.translatable((String)tooltipKey);
        return this.minecraft.font.split((FormattedText)tooltipComponent, this.layoutWidth / 2);
    }

    public int getRowWidth() {
        return this.getWidth() - (this.scrollbarVisible() ? 20 : 12);
    }

    public int getRowLeft() {
        return 6;
    }

    protected int scrollBarX() {
        return this.getRight() - 12;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        ConfigWidgetEntry hovered = (ConfigWidgetEntry)this.getHovered();
        if (hovered != null && hovered.tooltip != null) {
            guiGraphics.setTooltipForNextFrame(hovered.tooltip, mouseX, mouseY);
        }
    }
}

