/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.smoothiezapi.gui.widget.entries.handler;

import io.github.smootheez.smoothiezapi.config.ConfigOption;
import io.github.smootheez.smoothiezapi.config.OptionList;
import io.github.smootheez.smoothiezapi.gui.helper.ConfigTranslationHelper;
import io.github.smootheez.smoothiezapi.gui.widget.base.ConfigWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.BooleanWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.CycleWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.OptionListWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.TextDoubleWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.TextIntegerWidgetEntry;
import io.github.smootheez.smoothiezapi.gui.widget.entries.TextStringWidgetEntry;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@Environment(value=EnvType.CLIENT)
public interface WidgetHandler<T> {
    public ConfigWidgetEntry createWidget(ConfigOption<T> var1, String var2, @Nullable List<FormattedCharSequence> var3);

    @Environment(value=EnvType.CLIENT)
    public static class EnumHandler<E extends Enum<E>>
    implements WidgetHandler<E> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<E> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new CycleWidgetEntry<E>(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class OptionListHandler
    implements WidgetHandler<OptionList> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<OptionList> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new OptionListWidgetEntry(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class StringHandler
    implements WidgetHandler<String> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<String> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new TextStringWidgetEntry(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextDoubleHandler
    implements WidgetHandler<Double> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<Double> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new TextDoubleWidgetEntry(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextIntegerHandler
    implements WidgetHandler<Integer> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<Integer> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new TextIntegerWidgetEntry(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BooleanHandler
    implements WidgetHandler<Boolean> {
        @Override
        public ConfigWidgetEntry createWidget(ConfigOption<Boolean> option, String configId, @Nullable List<FormattedCharSequence> tooltip) {
            return new BooleanWidgetEntry(ConfigTranslationHelper.getTranslationKey(configId, option.getKey()), tooltip, option);
        }
    }
}

