/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.animation;

import com.clefal.nirvana_lib.client.render.animation.Easings;
import net.minecraft.world.phys.Vec3;

public class Frame {
    Vec3 position;
    Vec3 rotation;
    Vec3 scale;

    public Frame(Vec3 position, Vec3 rotation, Vec3 scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getRotation() {
        return this.rotation;
    }

    public Vec3 getScale() {
        return this.scale;
    }

    public Frame copy() {
        return new Frame(this.position, this.rotation, this.scale);
    }

    public Frame interpolate(Frame frame, float progress, Easings.Easing easing) {
        Vec3 position = this.position.m_82549_(frame.position.m_82546_(this.position).m_82490_((double)easing.ease(progress)));
        Vec3 rotation = this.rotation.m_82549_(frame.rotation.m_82546_(this.rotation).m_82490_((double)easing.ease(progress)));
        Vec3 scale = this.scale.m_82549_(frame.scale.m_82546_(this.scale).m_82490_((double)easing.ease(progress)));
        return new Frame(position, rotation, scale);
    }

    public Frame bezierInterpolate(Frame frame, float progress, Easings.Easing easing) {
        Vec3 p0 = this.position;
        Vec3 p1 = this.position.m_82549_(this.rotation);
        Vec3 p2 = frame.position.m_82549_(frame.rotation);
        Vec3 p3 = frame.position;
        Vec3 position = p0.m_82490_((double)((float)Math.pow(1.0f - progress, 3.0))).m_82549_(p1.m_82490_((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).m_82549_(p2.m_82490_((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).m_82549_(p3.m_82490_((double)((float)Math.pow(progress, 3.0))));
        Vec3 r0 = this.rotation;
        Vec3 r1 = this.rotation.m_82549_(this.scale);
        Vec3 r2 = frame.rotation.m_82549_(frame.scale);
        Vec3 r3 = frame.rotation;
        Vec3 rotation = r0.m_82490_((double)((float)Math.pow(1.0f - progress, 3.0))).m_82549_(r1.m_82490_((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).m_82549_(r2.m_82490_((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).m_82549_(r3.m_82490_((double)((float)Math.pow(progress, 3.0))));
        Vec3 s0 = this.scale;
        Vec3 s1 = this.scale.m_82549_(this.position);
        Vec3 s2 = frame.scale.m_82549_(frame.position);
        Vec3 s3 = frame.scale;
        Vec3 scale = s0.m_82490_((double)((float)Math.pow(1.0f - progress, 3.0))).m_82549_(s1.m_82490_((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).m_82549_(s2.m_82490_((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).m_82549_(s3.m_82490_((double)((float)Math.pow(progress, 3.0))));
        return new Frame(position, rotation, scale);
    }
}

