/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.relocated.net.neoforged.bus;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.BusBuilderImpl;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.ConsumerEventHandler;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.EventBusErrorMessage;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.ListenerList;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.LockHelper;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.LogMarkers;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.SubscribeEventListener;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.EventListener;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.EventPriority;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.ICancellableEvent;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.IEventBus;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.IEventClassChecker;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.IEventExceptionHandler;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.SubscribeEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jodah.typetools.TypeResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class EventBus
implements IEventExceptionHandler,
IEventBus {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean checkTypesOnDispatchProperty = Boolean.parseBoolean(System.getProperty("eventbus.checkTypesOnDispatch", "false"));
    private ConcurrentHashMap<Object, List<EventListener>> listeners = new ConcurrentHashMap();
    private final LockHelper<Class<?>, ListenerList> listenerLists = LockHelper.withIdentityHashMap();
    private final IEventExceptionHandler exceptionHandler;
    private volatile boolean shutdown = false;
    private final IEventClassChecker classChecker;
    private final boolean checkTypesOnDispatch;
    private final boolean allowPerPhasePost;

    private EventBus() {
        this(new BusBuilderImpl());
    }

    private EventBus(IEventExceptionHandler handler, boolean startShutdown, IEventClassChecker classChecker, boolean checkTypesOnDispatch, boolean allowPerPhasePost) {
        this.exceptionHandler = handler == null ? this : handler;
        this.shutdown = startShutdown;
        this.classChecker = classChecker;
        this.checkTypesOnDispatch = checkTypesOnDispatch || checkTypesOnDispatchProperty;
        this.allowPerPhasePost = allowPerPhasePost;
    }

    public EventBus(BusBuilderImpl busBuilder) {
        this(busBuilder.exceptionHandler, busBuilder.startShutdown, busBuilder.classChecker, busBuilder.checkTypesOnDispatch, busBuilder.allowPerPhasePost);
    }

    @Override
    public void register(Object target) {
        if (this.listeners.containsKey(target)) {
            return;
        }
        boolean isStatic = target.getClass() == Class.class;
        Class<?> clazz = isStatic ? (Class<?>)target : target.getClass();
        EventBus.checkSupertypes(clazz, clazz);
        int foundMethods = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
            if (Modifier.isStatic(method.getModifiers()) != isStatic) {
                if (isStatic) {
                    throw new IllegalArgumentException("Expected @SubscribeEvent method %s to be static\nbecause register() was called with a class type.\nEither make the method static, or call register() with an instance of %s.\n".formatted(method, clazz));
                }
                throw new IllegalArgumentException("Expected @SubscribeEvent method %s to NOT be static\nbecause register() was called with an instance type.\nEither make the method non-static, or call register(%s.class).\n".formatted(method, clazz.getSimpleName()));
            }
            this.registerListener(target, method, method);
            ++foundMethods;
        }
        if (foundMethods == 0) {
            throw new IllegalArgumentException("%s has no @SubscribeEvent methods, but register was called anyway.\nThe event bus only recognizes listener methods that have the @SubscribeEvent annotation.\n".formatted(clazz));
        }
    }

    private static void checkSupertypes(Class<?> registeredType, Class<?> type) {
        if (type == null || type == Object.class) {
            return;
        }
        if (type != registeredType) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
                throw new IllegalArgumentException("Attempting to register a listener object of type %s,\nhowever its supertype %s has a @SubscribeEvent method: %s.\nThis is not allowed! Only the listener object can have @SubscribeEvent methods.\n".formatted(registeredType, type, method));
            }
        }
        EventBus.checkSupertypes(registeredType, type.getSuperclass());
        Stream.of(type.getInterfaces()).forEach(itf -> EventBus.checkSupertypes(registeredType, itf));
    }

    private void registerListener(Object target, Method method, Method real) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation. It has " + parameterTypes.length + " arguments, but event handler methods require a single argument only.");
        }
        Class<?> eventType = parameterTypes[0];
        if (!Event.class.isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not an Event subtype : " + eventType);
        }
        try {
            this.classChecker.check(eventType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method " + method + " has @SubscribeEvent annotation, but takes an argument that is not valid for this bus" + eventType, e);
        }
        this.register(eventType, target, real);
    }

    @Nullable
    private <T extends Event> Predicate<T> passNotGenericFilter(boolean receiveCanceled) {
        return receiveCanceled ? null : e -> !((ICancellableEvent)((Object)e)).isCanceled();
    }

    @Override
    public <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.addListener(priority, false, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCanceled, Consumer<T> consumer) {
        this.addListener(priority, this.passNotGenericFilter(receiveCanceled), consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, false, eventType, consumer);
    }

    @Override
    public <T extends Event> void addListener(boolean receiveCanceled, Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, receiveCanceled, consumer);
    }

    @Override
    public <T extends Event> void addListener(boolean receiveCanceled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, receiveCanceled, eventType, consumer);
    }

    @Override
    public <T extends Event> void addListener(Class<T> eventType, Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, false, eventType, consumer);
    }

    @Override
    public <T extends Event> void addListener(EventPriority priority, boolean receiveCanceled, Class<T> eventType, Consumer<T> consumer) {
        this.addListener(priority, this.passNotGenericFilter(receiveCanceled), eventType, consumer);
    }

    private <T extends Event> Class<T> getEventClass(Consumer<T> consumer) {
        Class eventClass = TypeResolver.resolveRawArgument(Consumer.class, consumer.getClass());
        if (eventClass == TypeResolver.Unknown.class) {
            LOGGER.error(LogMarkers.EVENTBUS, "Failed to resolve handler for \"{}\"", (Object)consumer.toString());
            throw new IllegalStateException("Failed to resolve consumer event type: " + consumer.toString());
        }
        return eventClass;
    }

    private <T extends Event> void addListener(EventPriority priority, @Nullable Predicate<? super T> filter, Consumer<T> consumer) {
        Class<T> eventClass = this.getEventClass(consumer);
        if (Objects.equals(eventClass, Event.class)) {
            LOGGER.warn(LogMarkers.EVENTBUS, "Attempting to add a Lambda listener with computed generic type of Event. Are you sure this is what you meant? NOTE : there are complex lambda forms where the generic type information is erased and cannot be recovered at runtime.");
        }
        this.addListener(priority, filter, eventClass, consumer);
    }

    private <T extends Event> void addListener(EventPriority priority, @Nullable Predicate<? super T> filter, Class<T> eventClass, Consumer<T> consumer) {
        try {
            this.classChecker.check(eventClass);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Listener for event " + eventClass + " takes an argument that is not valid for this bus", e);
        }
        ConsumerEventHandler listener = filter == null ? new ConsumerEventHandler(consumer) : new ConsumerEventHandler.WithPredicate(consumer, filter);
        this.addToListeners(consumer, eventClass, listener, priority);
    }

    private void register(Class<?> eventType, Object target, Method method) {
        SubscribeEventListener listener = new SubscribeEventListener(target, method);
        this.addToListeners(target, eventType, listener, listener.getPriority());
    }

    private void addToListeners(Object target, Class<?> eventType, EventListener listener, EventPriority priority) {
        if (Modifier.isAbstract(eventType.getModifiers())) {
            throw new IllegalArgumentException("Cannot register listeners for abstract " + eventType + ". Register a listener to one of its subclasses instead!");
        }
        this.getListenerList(eventType).register(priority, listener);
        List others = this.listeners.computeIfAbsent(target, k -> Collections.synchronizedList(new ArrayList()));
        others.add(listener);
    }

    private ListenerList getListenerList(Class<?> eventType) {
        ListenerList list = this.listenerLists.get(eventType);
        if (list != null) {
            return list;
        }
        if (Modifier.isAbstract(eventType.getSuperclass().getModifiers())) {
            EventBus.validateAbstractChain(eventType.getSuperclass());
            return this.listenerLists.computeIfAbsent(eventType, e -> new ListenerList((Class<?>)e, this.allowPerPhasePost));
        }
        return this.listenerLists.computeIfAbsent(eventType, e -> new ListenerList((Class<?>)e, this.getListenerList(e.getSuperclass()), this.allowPerPhasePost));
    }

    private static void validateAbstractChain(Class<?> eventType) {
        while (eventType != Event.class) {
            if (!Modifier.isAbstract(eventType.getSuperclass().getModifiers())) {
                throw new IllegalArgumentException("Abstract event " + eventType + " has a non-abstract superclass " + eventType.getSuperclass() + ". The superclass must be made abstract.");
            }
            eventType = eventType.getSuperclass();
        }
    }

    @Override
    public void unregister(Object object) {
        List<EventListener> list = this.listeners.remove(object);
        if (list == null) {
            return;
        }
        for (ListenerList listenerList : this.listenerLists.getReadMap().values()) {
            for (EventListener listener : list) {
                listenerList.unregister(listener);
            }
        }
    }

    @Override
    public <T extends Event> T post(T event) {
        if (this.shutdown) {
            return event;
        }
        this.doPostChecks(event);
        return this.post(event, this.getListenerList(event.getClass()).getListeners());
    }

    @Override
    public <T extends Event> T post(EventPriority phase, T event) {
        if (!this.allowPerPhasePost) {
            throw new IllegalStateException("This bus does not allow calling phase-specific post.");
        }
        if (this.shutdown) {
            return event;
        }
        this.doPostChecks(event);
        return this.post(event, this.getListenerList(event.getClass()).getPhaseListeners(phase));
    }

    private void doPostChecks(Event event) {
        if (this.checkTypesOnDispatch) {
            try {
                this.classChecker.check(event.getClass());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot post event of type " + event.getClass().getSimpleName() + " to this bus", e);
            }
        }
    }

    private <T extends Event> T post(T event, EventListener[] listeners) {
        int index;
        try {
            for (index = 0; index < listeners.length; ++index) {
                listeners[index].invoke(event);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(this, event, listeners, index, throwable);
            throw throwable;
        }
        return event;
    }

    @Override
    public void handleException(IEventBus bus, Event event, EventListener[] listeners, int index, Throwable throwable) {
        LOGGER.error(LogMarkers.EVENTBUS, () -> new EventBusErrorMessage(event, index, listeners, throwable));
    }

    @Override
    public void start() {
        this.shutdown = false;
    }
}

