/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.platform;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.network.C2SModPacket;
import com.clefal.nirvana_lib.network.ClientHandler;
import com.clefal.nirvana_lib.network.S2CModPacket;
import com.clefal.nirvana_lib.network.ServerHandler;
import com.clefal.nirvana_lib.platform.services.IPlatformHelper;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public void sendToClient(S2CModPacket msg, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        msg.write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packet(msg.getClass()), (class_2540)buf);
    }

    @Override
    public void sendToServer(C2SModPacket msg) {
        class_2540 buf = PacketByteBufs.create();
        msg.write(buf);
        ClientPlayNetworking.send((class_2960)this.packet(msg.getClass()), (class_2540)buf);
    }

    @Override
    public <MSG extends S2CModPacket> void registerClientMessage(Class<MSG> packetClass, Function<class_2540, MSG> reader) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.packet(packetClass), new ClientHandler<MSG>(reader));
    }

    @Override
    public <MSG extends C2SModPacket> void registerServerMessage(Class<MSG> packetClass, Function<class_2540, MSG> reader) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.packet(packetClass), new ServerHandler<MSG>(reader));
    }

    protected class_2960 packet(Class<?> clazz) {
        return NirvanaLibConstants.id(clazz.getName().toLowerCase(Locale.ROOT));
    }
}

