/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.relocated.net.neoforged.bus;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.IWrapperListener;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.EventListener;
import java.util.function.Consumer;
import java.util.function.Predicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ConsumerEventHandler
extends EventListener {
    protected final Consumer<Event> consumer;

    public ConsumerEventHandler(Consumer<Event> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void invoke(Event event) {
        this.consumer.accept(event);
    }

    public String toString() {
        return this.consumer.toString();
    }

    public static final class WithPredicate
    extends ConsumerEventHandler
    implements IWrapperListener {
        private final Predicate<Event> predicate;
        private final EventListener withoutCheck;

        public WithPredicate(Consumer<Event> consumer, Predicate<Event> predicate) {
            super(consumer);
            this.predicate = predicate;
            this.withoutCheck = new ConsumerEventHandler(consumer);
        }

        @Override
        public void invoke(Event event) {
            if (this.predicate.test(event)) {
                this.consumer.accept(event);
            }
        }

        @Override
        public EventListener getWithoutCheck() {
            return this.withoutCheck;
        }
    }
}

