/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.network.packets;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.config.BooleanValue;
import com.clefal.nirvana_lib.config.ConfigValue;
import com.clefal.nirvana_lib.config.IntegerValue;
import com.clefal.nirvana_lib.config.PersonalConfigData;
import com.clefal.nirvana_lib.config.StringListValue;
import com.clefal.nirvana_lib.config.SyncingPersonalConfig;
import com.clefal.nirvana_lib.network.newtoolchain.C2SModPacket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class C2SSendSyncingConfigPacket
implements C2SModPacket<C2SSendSyncingConfigPacket> {
    public static ResourceLocation location = NirvanaLibConstants.id("send_syncing_config");
    public static final CustomPacketPayload.Type<C2SSendSyncingConfigPacket> TYPE = new CustomPacketPayload.Type(location);
    public static final StreamCodec<FriendlyByteBuf, C2SSendSyncingConfigPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2SSendSyncingConfigPacket::getPlayer, (StreamCodec)new StreamCodec<FriendlyByteBuf, Map<String, ConfigValue<?>>>(){

        public void encode(FriendlyByteBuf o, Map<String, ConfigValue<?>> stringConfigValueMap) {
            ArrayList<Byte> tokens = new ArrayList<Byte>();
            for (Map.Entry<String, ConfigValue<?>> e : stringConfigValueMap.entrySet()) {
                tokens.add(e.getValue().getToken());
            }
            o.writeCollection(tokens, (buf1, aByte) -> buf1.writeByte(aByte.byteValue()));
            for (Map.Entry<String, ConfigValue<?>> e : stringConfigValueMap.entrySet()) {
                o.writeUtf(e.getKey());
                e.getValue().write(o);
            }
        }

        public Map<String, ConfigValue<?>> decode(FriendlyByteBuf byteBuf) {
            List bytes = byteBuf.readList(FriendlyByteBuf::readByte);
            LinkedHashMap map = new LinkedHashMap();
            for (Byte token : bytes) {
                String key = byteBuf.readUtf();
                ConfigValue value = null;
                switch (token) {
                    case 0: {
                        value = new BooleanValue(byteBuf.readBoolean());
                        break;
                    }
                    case 1: {
                        value = new IntegerValue(Byte.valueOf(byteBuf.readByte()).intValue());
                        break;
                    }
                    case 2: {
                        value = new StringListValue((List)byteBuf.readCollection(ArrayList::new, FriendlyByteBuf::readUtf));
                    }
                }
                if (value == null) {
                    throw new RuntimeException("invalidated token: " + token);
                }
                map.put(key, value);
            }
            return map;
        }
    }, C2SSendSyncingConfigPacket::getMap, C2SSendSyncingConfigPacket::new);
    private UUID player;
    private Map<String, ConfigValue<?>> map;

    public C2SSendSyncingConfigPacket(UUID player, Map<String, ConfigValue<?>> configs) {
        this.player = player;
        this.map = configs;
    }

    public C2SSendSyncingConfigPacket() {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handleServer(ServerPlayer sender, C2SSendSyncingConfigPacket message, boolean isClient) {
        PersonalConfigData data = SyncingPersonalConfig.INSTANCE.getData(message.player);
        for (Map.Entry<String, ConfigValue<?>> e : message.map.entrySet()) {
            data.configMap.merge(e.getKey(), e.getValue(), (old, newOne) -> newOne);
        }
    }

    @Generated
    public UUID getPlayer() {
        return this.player;
    }

    @Generated
    public Map<String, ConfigValue<?>> getMap() {
        return this.map;
    }
}

