/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.network.packets;

import com.clefal.nirvana_lib.config.BooleanValue;
import com.clefal.nirvana_lib.config.ConfigValue;
import com.clefal.nirvana_lib.config.IntegerValue;
import com.clefal.nirvana_lib.config.PersonalConfigData;
import com.clefal.nirvana_lib.config.StringListValue;
import com.clefal.nirvana_lib.config.SyncingPersonalConfig;
import com.clefal.nirvana_lib.network.newtoolchain.C2SModPacket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class C2SSendSyncingConfigPacket
implements C2SModPacket<C2SSendSyncingConfigPacket> {
    private UUID player;
    private Map<String, ConfigValue<?>> map;

    public C2SSendSyncingConfigPacket(UUID player, Map<String, ConfigValue<?>> configs) {
        this.player = player;
        this.map = configs;
    }

    public C2SSendSyncingConfigPacket() {
    }

    @Override
    public void handleServer(ServerPlayer sender, C2SSendSyncingConfigPacket message, boolean isClient) {
        PersonalConfigData data = SyncingPersonalConfig.INSTANCE.getData(message.player);
        for (Map.Entry<String, ConfigValue<?>> e : message.map.entrySet()) {
            data.configMap.merge(e.getKey(), e.getValue(), (old, newOne) -> newOne);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.player);
        ArrayList<Byte> tokens = new ArrayList<Byte>();
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            tokens.add(e.getValue().getToken());
        }
        buf.writeCollection(tokens, (buf1, aByte) -> buf1.writeByte(aByte.byteValue()));
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            buf.writeUtf(e.getKey());
            e.getValue().write(buf);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.player = buf.readUUID();
        List bytes = buf.readList(FriendlyByteBuf::readByte);
        LinkedHashMap map = new LinkedHashMap();
        for (Byte token : bytes) {
            String key = buf.readUtf();
            ConfigValue value = null;
            switch (token) {
                case 0: {
                    value = new BooleanValue(buf.readBoolean());
                    break;
                }
                case 1: {
                    value = new IntegerValue(Byte.valueOf(buf.readByte()).intValue());
                    break;
                }
                case 2: {
                    value = new StringListValue((List)buf.readCollection(ArrayList::new, FriendlyByteBuf::readUtf));
                }
            }
            if (value == null) {
                throw new RuntimeException("invalidated token: " + token);
            }
            map.put(key, value);
        }
        this.map = map;
    }

    @Override
    public Class<C2SSendSyncingConfigPacket> getSelfClass() {
        return C2SSendSyncingConfigPacket.class;
    }

    @Generated
    public UUID getPlayer() {
        return this.player;
    }

    @Generated
    public Map<String, ConfigValue<?>> getMap() {
        return this.map;
    }
}

