/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.utils;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.network.C2SModPacket;
import com.clefal.nirvana_lib.network.S2CModPacket;
import com.clefal.nirvana_lib.network.newtoolchain.ModPacket;
import commonnetwork.api.Dispatcher;
import commonnetwork.api.Network;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9139;

public final class NetworkUtils {
    public static <T> void sendToClient(T msg, class_3222 player) {
        Dispatcher.sendToClient(msg, (class_3222)player);
    }

    public static <T> void sendToClients(T msg, Iterable<class_3222> playerList) {
        playerList.forEach(x -> NetworkUtils.sendToClient(msg, x));
    }

    public static <T> void sendToServer(T msg) {
        Dispatcher.sendToServer(msg);
    }

    @Deprecated(forRemoval=true)
    public static void sendToClient(S2CModPacket msg, class_3222 player) {
        Dispatcher.sendToClient((Object)msg, (class_3222)player);
    }

    @Deprecated(forRemoval=true)
    public static void sendToClients(S2CModPacket msg, Iterable<class_3222> playerList) {
        for (class_3222 serverPlayer : playerList) {
            NetworkUtils.sendToClient(msg, serverPlayer);
        }
    }

    @Deprecated(forRemoval=true)
    public static void sendToServer(C2SModPacket msg) {
        Dispatcher.sendToServer((Object)msg);
    }

    public static <MSG extends ModPacket<MSG>> void registerPacket(Supplier<MSG> supplier) {
        Class selfClass = ((ModPacket)supplier.get()).getSelfClass();
        class_9139 codec = class_9139.method_56437((buf, msg) -> msg.write((class_2540)buf), buf -> {
            ModPacket msg = (ModPacket)supplier.get();
            msg.read((class_2540)buf);
            return msg;
        });
        Network.registerPacket(((ModPacket)supplier.get()).method_56479(), selfClass, (class_9139)codec, x -> ((ModPacket)x.message()).handle(x));
    }

    @Deprecated(forRemoval=true)
    public static <MSG extends C2SModPacket> void registerServerMessage(Class<MSG> packetClass, Function<class_2540, MSG> reader) {
        Network.registerPacket((class_2960)NetworkUtils.classToResourceLocation(packetClass), packetClass, com.clefal.nirvana_lib.network.ModPacket::write, reader, x -> ((C2SModPacket)x.message()).handleServer(x.sender()));
    }

    @Deprecated(forRemoval=true)
    public static <MSG extends S2CModPacket> void registerClientMessage(Class<MSG> packetClass, Function<class_2540, MSG> reader) {
        Network.registerPacket((class_2960)NetworkUtils.classToResourceLocation(packetClass), packetClass, com.clefal.nirvana_lib.network.ModPacket::write, reader, x -> ((S2CModPacket)x.message()).handleClient());
    }

    public static class_2960 classToResourceLocation(Class<?> clas) {
        String name = clas.getSimpleName().toLowerCase();
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char c : name.toCharArray()) {
            characters.add(Character.valueOf(c));
        }
        String result = characters.stream().filter(NetworkUtils::validPathChar).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        return NirvanaLibConstants.id(result.toLowerCase());
    }

    public static boolean validPathChar(char pathChar) {
        return pathChar == '_' || pathChar == '-' || pathChar >= 'a' && pathChar <= 'z' || pathChar >= '0' && pathChar <= '9' || pathChar == '/' || pathChar == '.';
    }

    @Generated
    private NetworkUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

