/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.lang;

import com.clefal.nirvana_lib.client.lang.ILangEntry;
import com.clefal.nirvana_lib.client.lang.LangCreator;
import com.clefal.nirvana_lib.client.lang.LangPair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;

public class WithDescLangEntry
implements ILangEntry {
    private final LangPair main;
    private final List<LangPair> descs;

    private WithDescLangEntry(LangPair main, List<LangPair> descs) {
        this.main = main;
        this.descs = descs;
    }

    public MutableComponent get() {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.main.getKey(), null, TranslatableContents.f_237494_));
    }

    public MutableComponent get(Object ... args) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.main.getKey(), null, args));
    }

    public MutableComponent getDesc(int index) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.descs.get(index).getKey(), null, TranslatableContents.f_237494_));
    }

    public MutableComponent getDesc(int index, Object ... args) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.descs.get(index).getKey(), null, args));
    }

    public List<MutableComponent> getAllDesc() {
        ArrayList<MutableComponent> mutableComponents = new ArrayList<MutableComponent>();
        for (LangPair desc : this.descs) {
            mutableComponents.add(MutableComponent.m_237204_((ComponentContents)new TranslatableContents(desc.getKey(), null, TranslatableContents.f_237494_)));
        }
        return mutableComponents;
    }

    @Override
    public Supplier<List<LangPair>> provide() {
        return () -> {
            List<LangPair> main1 = List.of(this.main);
            main1.addAll(this.descs);
            return main1;
        };
    }

    public static final class WithDescLangEntryBuilder {
        private String modId;
        private List<String> categories;
        private String keySuffix;
        private String value;
        private List<String> descsValue;
        private String descSuffix;

        public WithDescLangEntryBuilder(String modId, List<String> categories) {
            this.modId = modId;
            this.categories = categories;
            this.descsValue = new ArrayList<String>();
        }

        public WithDescLangEntryBuilder lang(String keySuffix, String value) {
            this.keySuffix = keySuffix;
            this.value = value;
            return this;
        }

        public WithDescLangEntryBuilder desc(String value) {
            this.descsValue.add(value);
            return this;
        }

        public WithDescLangEntryBuilder defaultDescSuffix() {
            this.descSuffix = "desc";
            return this;
        }

        public WithDescLangEntry build() {
            StringBuilder base = new StringBuilder();
            base.append(this.modId);
            for (String category : this.categories) {
                base.append(".").append(category);
            }
            String baseKey = base.toString();
            StringBuilder mainKey = base.append(".").append(this.keySuffix);
            ArrayList<LangPair> descs = new ArrayList<LangPair>();
            for (int i = 0; i < this.descsValue.size(); ++i) {
                descs.add(LangPair.of(baseKey + "." + this.descSuffix + "." + i + "1", this.descsValue.get(i)));
            }
            WithDescLangEntry withDescLangEntry = new WithDescLangEntry(LangPair.of(mainKey.toString(), this.value), descs);
            LangCreator.entries.add(withDescLangEntry);
            return withDescLangEntry;
        }
    }
}

