/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.network.packets;

import com.clefal.nirvana_lib.config.BooleanValue;
import com.clefal.nirvana_lib.config.ConfigValue;
import com.clefal.nirvana_lib.config.IntegerValue;
import com.clefal.nirvana_lib.config.PersonalConfigData;
import com.clefal.nirvana_lib.config.StringListValue;
import com.clefal.nirvana_lib.config.SyncingPersonalConfig;
import com.clefal.nirvana_lib.network.C2SModPacket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class C2SSendSyncingConfigPacket
implements C2SModPacket {
    private final UUID player;
    private final Map<String, ConfigValue<?>> map;
    private List<Byte> tokens = new ArrayList<Byte>();

    public C2SSendSyncingConfigPacket(UUID player, Map<String, ConfigValue<?>> configs) {
        this.player = player;
        this.map = configs;
    }

    public C2SSendSyncingConfigPacket(class_2540 buf) {
        this.player = buf.method_10790();
        this.tokens = buf.method_34066(class_2540::readByte);
        LinkedHashMap map = new LinkedHashMap();
        for (Byte token : this.tokens) {
            String key = buf.method_19772();
            ConfigValue value = null;
            switch (token) {
                case 0: {
                    value = new BooleanValue(buf.readBoolean());
                    break;
                }
                case 1: {
                    value = new IntegerValue(Byte.valueOf(buf.readByte()).intValue());
                    break;
                }
                case 2: {
                    value = new StringListValue((List)buf.method_34068(ArrayList::new, class_2540::method_19772));
                }
            }
            if (value == null) {
                throw new RuntimeException("invalidated token: " + token);
            }
            map.put(key, value);
        }
        this.map = map;
    }

    @Override
    public void handleServer(class_3222 player) {
        PersonalConfigData data = SyncingPersonalConfig.INSTANCE.getData(this.player);
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            data.configMap.merge(e.getKey(), e.getValue(), (old, newOne) -> newOne);
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.player);
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            this.tokens.add(e.getValue().getToken());
        }
        buf.method_34062(this.tokens, (buf1, aByte) -> buf1.writeByte((int)aByte.byteValue()));
        for (Map.Entry<String, ConfigValue<?>> e : this.map.entrySet()) {
            buf.method_10814(e.getKey());
            e.getValue().write(buf);
        }
    }
}

