/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.network.packets;

import com.clefal.nirvana_lib.NirvanaLibConstants;
import com.clefal.nirvana_lib.config.BooleanValue;
import com.clefal.nirvana_lib.config.ConfigValue;
import com.clefal.nirvana_lib.config.IntegerValue;
import com.clefal.nirvana_lib.config.PersonalConfigData;
import com.clefal.nirvana_lib.config.StringListValue;
import com.clefal.nirvana_lib.config.SyncingPersonalConfig;
import com.clefal.nirvana_lib.network.newtoolchain.C2SModPacket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class C2SSendSyncingConfigPacket
implements C2SModPacket<C2SSendSyncingConfigPacket> {
    public static class_2960 location = NirvanaLibConstants.id("send_syncing_config");
    public static final class_8710.class_9154<C2SSendSyncingConfigPacket> TYPE = new class_8710.class_9154(location);
    public static final class_9139<class_2540, C2SSendSyncingConfigPacket> CODEC = class_9139.method_56435((class_9139)class_4844.field_48453, C2SSendSyncingConfigPacket::getPlayer, (class_9139)new class_9139<class_2540, Map<String, ConfigValue<?>>>(){

        public void encode(class_2540 o, Map<String, ConfigValue<?>> stringConfigValueMap) {
            ArrayList<Byte> tokens = new ArrayList<Byte>();
            for (Map.Entry<String, ConfigValue<?>> e : stringConfigValueMap.entrySet()) {
                tokens.add(e.getValue().getToken());
            }
            o.method_34062(tokens, (buf1, aByte) -> buf1.method_52997((int)aByte.byteValue()));
            for (Map.Entry<String, ConfigValue<?>> e : stringConfigValueMap.entrySet()) {
                o.method_10814(e.getKey());
                e.getValue().write(o);
            }
        }

        public Map<String, ConfigValue<?>> decode(class_2540 byteBuf) {
            List bytes = byteBuf.method_34066(class_2540::readByte);
            LinkedHashMap map = new LinkedHashMap();
            for (Byte token : bytes) {
                String key = byteBuf.method_19772();
                ConfigValue value = null;
                switch (token) {
                    case 0: {
                        value = new BooleanValue(byteBuf.readBoolean());
                        break;
                    }
                    case 1: {
                        value = new IntegerValue(Byte.valueOf(byteBuf.readByte()).intValue());
                        break;
                    }
                    case 2: {
                        value = new StringListValue((List)byteBuf.method_34068(ArrayList::new, class_2540::method_19772));
                    }
                }
                if (value == null) {
                    throw new RuntimeException("invalidated token: " + token);
                }
                map.put(key, value);
            }
            return map;
        }
    }, C2SSendSyncingConfigPacket::getMap, C2SSendSyncingConfigPacket::new);
    private UUID player;
    private Map<String, ConfigValue<?>> map;

    public C2SSendSyncingConfigPacket(UUID player, Map<String, ConfigValue<?>> configs) {
        this.player = player;
        this.map = configs;
    }

    public C2SSendSyncingConfigPacket() {
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    @Override
    public void handleServer(class_3222 sender, C2SSendSyncingConfigPacket message, boolean isClient) {
        PersonalConfigData data = SyncingPersonalConfig.INSTANCE.getData(message.player);
        for (Map.Entry<String, ConfigValue<?>> e : message.map.entrySet()) {
            data.configMap.merge(e.getKey(), e.getValue(), (old, newOne) -> newOne);
        }
    }

    @Generated
    public UUID getPlayer() {
        return this.player;
    }

    @Generated
    public Map<String, ConfigValue<?>> getMap() {
        return this.map;
    }
}

